unit uCompress;

interface
{$DEFINE FXC}   // FlexCompress
{DEFINE ZF}	// ZipForge
{DEFINE VCLZIP}
{DEFINE ZIPTV}
{DEFINE ABBREVIA}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  Gauges, ExtCtrls,
{$IFDEF FXC}
 FlexCompress
{$ENDIF}
{$IFDEF ZF}
 FlexCompress
// ZipForge
{$ENDIF}
{$IFDEF VCLZIP}
 VCLZip
{$ENDIF}
{$IFDEF ZIPTV}
 ztvZip,ztvBase,ztvUnZip
{$ENDIF}
{$IFDEF ABBREVIA}
 AbZipper,AbUnzper,AbZiptyp,AbCabMak,AbCabExt
{$ENDIF}
 ;

var TestDataSize: integer;
    LogFileName: string;

type
  TForm1 = class(TForm)
    Log: TMemo;
    Panel1: TPanel;
    Button1: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
   procedure TestIt;
   procedure WriteLog(s: string);
   procedure RunTest;
  end;

var
  Form1: 	TForm1;
  level: 	Integer;
  time: 	Cardinal;
  fileSize:	Int64;
  compressSize:	Int64;
  compressSize2:Int64;

implementation

{$R *.DFM}


function CountDataSize(FileName: string): Integer;
var sr: TSearchRec;
begin
 result := 0;
 if (FindFirst(FileName,faAnyFile,sr) = 0) then
  repeat
   result := result + sr.Size;
  until FindNext(sr) <> 0;
end;

procedure DeleteFiles(StartPath: string);
 procedure DeleteAll(Path: string);
 var sr: TSearchRec;
 begin
  if (FindFirst(Path+'*.*',faAnyFile,sr) = 0) then
   repeat
    if (sr.Name = '.') or (sr.Name = '..') then
     continue; 
    if ((sr.Attr and faDirectory) <> 0) then
     begin
      // directory
      DeleteAll(Path+sr.Name+'\');
      RemoveDir(Path+sr.Name);
     end
    else
     DeleteFile(Path+sr.Name);
   until FindNext(sr) <> 0;
 end;

begin
 DeleteAll(StartPath);
end;


procedure TForm1.WriteLog(s: string);
begin
 Log.Lines.Add(s);
 Log.Lines.SaveToFile(LogFileName);
end;

function GetTime: string;
var sec,min,s100: LongInt;
begin
 s100 := time mod 1000;
 sec := (integer(time) - s100) div 1000;
 min := sec div 60;
 sec := sec mod 60;
 result := ','+Format(' %4u:%2u.%3u',[min,sec,s100]);
 Result := result +', '+IntToStr(time);
//FormatFloat('#,##0.000',time) 
 result := result +', ms';
end;

{$IFDEF FXC}
procedure TForm1.TestIt;
const ArcFileName = 'Archive\test.fxc';
var arc: TFlexCompress;
    inStrm: TFileStream;

 procedure ProcessFiles;
 var i: integer;
     s: string;
 begin
  for i := 1 to 9 do
   begin
    Application.ProcessMessages;
    if (Application.Terminated) then
     begin
      WriteLog('Terminated!');
      Exit;
     end;
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc.FileName := ArcFileName;
    arc.CompressionMode := i;
    try
      arc.OpenArchive(fmCreate);
      arc.BaseDir := 'Data';
      arc.AddFiles('*.*');
      WriteLog(#13#10+'Mode '+IntToStr(i)+' - Compression OK');
    except
      arc.CloseArchive;
      WriteLog('Mode '+IntToStr(i)+' - Compression failed');
    end;
    arc.CloseArchive;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName)) then
     begin
      inStrm := TFileStream.Create(ArcFileName,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s := GetTime;
    time := GetTickCount;
    try
      arc.OpenArchive(fmOpenRead);
      arc.BaseDir := 'Temp\';
      arc.ExtractFiles('*.*');
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog('Mode '+IntToStr(i)+' - Decompression failed')
      else
       WriteLog('Mode '+IntToStr(i)+' - Deompression OK');
    except
      arc.CloseArchive;
      WriteLog('Mode '+IntToStr(i)+' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');
   end; // modes
 end; // ProcessFiles


begin
 LogFileName := 'Logs\FlexCompress100.csv';
 arc := TFlexCompress.Create(self);

 arc.CompressionAlgorithm := caZLIB;
 WriteLog('Testing FlexCompress, caZLIB ...');
 ProcessFiles;

 WriteLog('Testing FlexCompress, caBZIP ...');
 arc.CompressionAlgorithm := caBZIP;
 ProcessFiles;

 WriteLog('Testing FlexCompress, caPPM ...');
 arc.CompressionAlgorithm := caPPM;
 ProcessFiles;
 arc.Free;
end; // FlexCompress
{$ENDIF} // FXC


{$IFDEF ZF}
procedure TForm1.TestIt;
const ArcFileName = 'Archive\test_zf.zip';
var arc: TZipForge;
    inStrm: TFileStream;

 procedure ProcessFiles;
 var i: integer;
     s: string;
 begin
  for i := 1 to 9 do
   begin
    Application.ProcessMessages;
    if (Application.Terminated) then
     begin
      WriteLog('Terminated!');
      Exit;
     end;
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc.FileName := ArcFileName;
    arc.CompressionMode := i;
    try
      arc.OpenArchive(fmCreate);
      arc.BaseDir := 'Data';
      arc.AddFiles('*.*');
      WriteLog(#13#10+'Mode '+IntToStr(i)+' - Compression OK');
    except
      arc.CloseArchive;
      WriteLog('Mode '+IntToStr(i)+' - Compression failed');
    end;
    arc.CloseArchive;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName)) then
     begin
      inStrm := TFileStream.Create(ArcFileName,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s := GetTime;
    time := GetTickCount;
    try
      arc.OpenArchive(fmOpenRead);
      arc.BaseDir := 'Temp\';
      arc.ExtractFiles('*.*');
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog('Mode '+IntToStr(i)+' - Decompression failed')
      else
       WriteLog('Mode '+IntToStr(i)+' - Deompression OK');
    except
      arc.CloseArchive;
      WriteLog('Mode '+IntToStr(i)+' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');
   end; // modes
 end; // ProcessFiles


begin
 LogFileName := 'Logs\ZipForge100.csv';
 arc := TZipForge.Create(self);
 WriteLog('Testing ZipForge ...');
 ProcessFiles;
 arc.Free;
end; // ZipForge
{$ENDIF} // ZF

{$IFDEF VCLZIP}
procedure TForm1.TestIt;
const ArcFileName = 'Archive\test_vclzip.zip';
var arc: TVCLZip;
    inStrm: TFileStream;

 procedure ProcessFiles;
 var i: integer;
     s: string;
 begin
  for i := 1 to 9 do
   begin
    Application.ProcessMessages;
    if (Application.Terminated) then
     begin
      WriteLog('Terminated!');
      Exit;
     end;
    arc := TVCLZip.Create(self);
    arc.FilesList.Add('*.*');
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc.ZipName := ArcFileName;
    arc.PackLevel := i;
    try
      arc.ZipName := ArcFileName;
      arc.RootDir := 'Data';
      arc.Zip;
      WriteLog(#13#10+'Mode '+IntToStr(i)+' - Compression OK');
    except
      WriteLog('Mode '+IntToStr(i)+' - Compression failed');
    end;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName)) then
     begin
      inStrm := TFileStream.Create(ArcFileName,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s := GetTime;
    time := GetTickCount;
    try
      arc.ReadZip;
      arc.DestDir := 'Temp\';
      arc.RootDir := '';
      arc.DoAll := true;
      arc.UnZIP;
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog('Mode '+IntToStr(i)+' - Decompression failed')
      else
       WriteLog('Mode '+IntToStr(i)+' - Deompression OK');
    except
      WriteLog('Mode '+IntToStr(i)+' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');
    arc.Free;
   end; // modes
 end; // ProcessFiles


begin
 LogFileName := 'Logs\VCLZIP223.csv';
 WriteLog('Testing VCLZIP ...');
 ProcessFiles;
end; // VCLZIP
{$ENDIF} // VCLZIP


{$IFDEF ZIPTV}
procedure TForm1.TestIt;
const ArcFileName = 'Archive\test_ziptv.zip';
var arc: TZip;
    unarc: TUnZip;
    inStrm: TFileStream;

 procedure ProcessFiles;
 var i: integer;
     s,s1: string;
 begin
  for i := 0 to 2 do
   begin
    Application.ProcessMessages;
    if (Application.Terminated) then
     begin
      WriteLog('Terminated!');
      Exit;
     end;
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc.ArchiveFile := ArcFileName;
    if (i = 0) then
     begin
      s := 'DeflateF';
      arc.DeflateType := dtDeflateF
     end
    else
    if (i = 1) then
     begin
      s := 'DeflateN';
      arc.DeflateType := dtDeflateN
     end
    else
     begin
      s := 'DeflateX';
      arc.DeflateType := dtDeflateX
     end;

    try
      arc.DefaultDir := 'Data';
      arc.Compress;
      WriteLog(#13#10+'Mode '+s  + ' - Compression OK');
    except
      WriteLog(#13#10+'Mode '+s  +' - Compression failed');
    end;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName)) then
     begin
      inStrm := TFileStream.Create(ArcFileName,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s1 := GetTime;
    time := GetTickCount;
    unarc.ArchiveFile := ArcFileName;
    try
      unarc.Extract;
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed')
      else
       WriteLog(#13#10+'Mode '+s  + ' - Decompression OK');
    except
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s1);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');
   end; // modes
 end; // ProcessFiles


begin
 LogFileName := 'Logs\ZipTV4.csv';
 arc := TZip.Create(self);
 unarc := TUnZip.Create(self);
 arc.FileSpec.Text := ExtractFilePath(Application.ExeName)+'Data'+'\*.*';
 unarc.ExtractDir := ExtractFilePath(Application.ExeName)+'Temp\';
 unarc.FileSpec.Text := '*.*';
 WriteLog('Testing ZIPTV ...');
 ProcessFiles;
 arc.Free;
 unarc.Free;
end; // ZIPTV
{$ENDIF} // ZIPTV


{$IFDEF ABBREVIA}
procedure TForm1.TestIt;
var ArcFileName: string;
var ArcFileName1: string;
var arc: TAbZipper;
    unarc: TAbUnZipper;
    arc1: TAbMakeCab;
    unarc1: TAbCabExtractor;
    inStrm: TFileStream;

 procedure ProcessFiles;
 var i: integer;
     s,s1: string;
 begin
  ArcFileName := ExtractFilePath(Application.ExeName)+'Archive\test_abbrevia.zip';
  ArcFileName1 := ExtractFilePath(Application.ExeName)+'Archive\test_abbrevia.cab';

  for i := 0 to 3 do
   begin
    Application.ProcessMessages;
    if (Application.Terminated) then
     begin
      WriteLog('Terminated!');
      Exit;
     end;
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc := TAbZipper.Create(self);
    arc.OpenArchive(ArcFileName);
    if (i = 0) then
     begin
      s := 'doSuperFast';
      arc.DeflationOption := doSuperFast;
     end
    else
    if (i = 1) then
     begin
      s := 'doFast';
      arc.DeflationOption := doFast;
     end
    else
    if (i = 2) then
     begin
      s := 'doNormal';
      arc.DeflationOption := doNormal;
     end
    else
     begin
      s := 'doMax';
      arc.DeflationOption := doMaximum;
     end;

    try
      arc.BaseDirectory := ExtractFilePath(Application.ExeName)+'Data';
      arc.AddFiles('*.*',faAnyFile);
      arc.CloseArchive;
      arc.Free;
      WriteLog(#13#10+'Mode '+s  + ' - Compression OK');
    except
      WriteLog(#13#10+'Mode '+s  +' - Compression failed');
    end;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName)) then
     begin
      inStrm := TFileStream.Create(ArcFileName,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s1 := GetTime;
    time := GetTickCount;
    unarc := TAbUnZipper.Create(self);
    unarc.BaseDirectory := ExtractFilePath(Application.ExeName)+'Temp';
    unarc.FileName := ArcFileName;
    try
      unarc.ExtractFiles('*.*');
      unarc.Free;
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed')
      else
       WriteLog(#13#10+'Mode '+s  + ' - Decompression OK');
    except
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s1);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');
   end; // modes


  // cab
    DeleteFile(ArcFileName);
    DeleteFiles('Temp\');
    time := GetTickCount;
    arc1 := TAbMakeCab.Create(self);
    arc1.OpenArchive(ArcFileName1);
    s := 'Cab';
    try
      arc1.BaseDirectory := ExtractFilePath(Application.ExeName)+'Data';
      arc1.AddFiles('*.*',faAnyFile);
      arc1.CloseArchive;
      arc1.Free;
      WriteLog(#13#10+'Mode '+s  + ' - Compression OK');
    except
      WriteLog(#13#10+'Mode '+s  +' - Compression failed');
    end;
    time := GetTickCount - time;
    fileSize := 0;
    if (FileExists(ArcFileName1)) then
     begin
      inStrm := TFileStream.Create(ArcFileName1,fmOpenRead);
      compressSize := inStrm.Size;
      inStrm.Free;
     end;
    s1 := GetTime;
    time := GetTickCount;
    unarc1 := TAbCabExtractor.Create(self);
    unarc1.BaseDirectory := ExtractFilePath(Application.ExeName)+'Temp';
    unarc1.FileName := ArcFileName1;
    try
      unarc1.ExtractFiles('*.*');
      unarc1.Free;
      if (CountDataSize('Temp\*.*') <> TestDataSize) then
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed')
      else
       WriteLog(#13#10+'Mode '+s  + ' - Decompression OK');
    except
       WriteLog(#13#10+'Mode '+s  + ' - Decompression failed');
    end;
    time := GetTickCount - time;
    WriteLog('Compression time:'+s1);
    WriteLog('Decompression time:'+GetTime);
    WriteLog('Uncompressed size:,'+InttoStr(TestDataSize));
    WriteLog('Compressed size:,'+InttoStr(compressSize));
    WriteLog('Compression rate:,'+Format('%f',
       [(1-compressSize/TestDataSize)*100.0])+',%');

 end; // ProcessFiles


begin
 LogFileName := 'Logs\ABBREVIA3.csv';
// arc.FileSpec.Text := ExtractFilePath(Application.ExeName)+'Data'+'\*.*';
// unarc.ExtractDir := ExtractFilePath(Application.ExeName)+'Temp\';
// unarc.FileSpec.Text := '*.*';
 WriteLog('Testing ABBREVIA ...');
 ProcessFiles;
end; // ABBREVIA
{$ENDIF} // ABBREVIA


procedure Tform1.RunTest;
begin
 DecimalSeparator := '.';
   try
    TestIt;
    WriteLog('Test completed.');
   except
  	WriteLog('Test error!');
   end;
 Form1.Close;
 Application.Terminate;
end;
procedure TForm1.FormActivate(Sender: TObject);
begin
 RunTest;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 Application.Terminate;
 Close;
 Application.ProcessMessages;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 TestDataSize := CountDataSize('Data\*.*');
end;

end.
