using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Caesar.SharpReader.Plugins
{
	/// <summary>
	/// Summary description for MailItemConfig.
	/// </summary>
	public class MailItemConfig : System.Windows.Forms.Form
	{
		private string _smtpServer = "";
		private string _nameFrom = "Sharpreader Mail Plugin";
		private string _nameTo = "anyone interested";
		private string _emailFrom = "";
		private string _emailTo = "";

		private System.Windows.Forms.Button OkButton;
		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.TextBox SmtpBox;
		private System.Windows.Forms.Label SmtpLabel;
		private System.Windows.Forms.Label ToEmailLabel;
		private System.Windows.Forms.Label FromEmailLabel;
		private System.Windows.Forms.Label FromNameLabel;
		private System.Windows.Forms.Label ToNameLabel;
		private System.Windows.Forms.TextBox ToEmailBox;
		private System.Windows.Forms.TextBox FromEmailBox;
		private System.Windows.Forms.TextBox FromNameBox;
		private System.Windows.Forms.TextBox ToNameBox;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MailItemConfig()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			ResetDialog();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(MailItemConfig));
			this.ToEmailLabel = new System.Windows.Forms.Label();
			this.ToEmailBox = new System.Windows.Forms.TextBox();
			this.OkButton = new System.Windows.Forms.Button();
			this.CloseButton = new System.Windows.Forms.Button();
			this.SmtpBox = new System.Windows.Forms.TextBox();
			this.SmtpLabel = new System.Windows.Forms.Label();
			this.FromEmailBox = new System.Windows.Forms.TextBox();
			this.FromEmailLabel = new System.Windows.Forms.Label();
			this.FromNameBox = new System.Windows.Forms.TextBox();
			this.FromNameLabel = new System.Windows.Forms.Label();
			this.ToNameBox = new System.Windows.Forms.TextBox();
			this.ToNameLabel = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// ToEmailLabel
			// 
			this.ToEmailLabel.Location = new System.Drawing.Point(8, 120);
			this.ToEmailLabel.Name = "ToEmailLabel";
			this.ToEmailLabel.Size = new System.Drawing.Size(80, 23);
			this.ToEmailLabel.TabIndex = 8;
			this.ToEmailLabel.Text = "To email:";
			// 
			// ToEmailBox
			// 
			this.ToEmailBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.ToEmailBox.Location = new System.Drawing.Point(96, 120);
			this.ToEmailBox.Name = "ToEmailBox";
			this.ToEmailBox.Size = new System.Drawing.Size(208, 20);
			this.ToEmailBox.TabIndex = 9;
			this.ToEmailBox.Text = "";
			// 
			// OkButton
			// 
			this.OkButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.OkButton.Location = new System.Drawing.Point(230, 158);
			this.OkButton.Name = "OkButton";
			this.OkButton.TabIndex = 11;
			this.OkButton.Text = "&Ok";
			this.OkButton.Click += new System.EventHandler(this.OkButton_Click);
			// 
			// CloseButton
			// 
			this.CloseButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.CloseButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.CloseButton.Location = new System.Drawing.Point(16, 160);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.TabIndex = 10;
			this.CloseButton.Text = "&Cancel";
			this.CloseButton.Click += new System.EventHandler(this.CloseButton_Click);
			// 
			// SmtpBox
			// 
			this.SmtpBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.SmtpBox.Location = new System.Drawing.Point(96, 64);
			this.SmtpBox.Name = "SmtpBox";
			this.SmtpBox.Size = new System.Drawing.Size(208, 20);
			this.SmtpBox.TabIndex = 5;
			this.SmtpBox.Text = "";
			// 
			// SmtpLabel
			// 
			this.SmtpLabel.Location = new System.Drawing.Point(8, 64);
			this.SmtpLabel.Name = "SmtpLabel";
			this.SmtpLabel.Size = new System.Drawing.Size(80, 23);
			this.SmtpLabel.TabIndex = 4;
			this.SmtpLabel.Text = "SMTP server:";
			// 
			// FromEmailBox
			// 
			this.FromEmailBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.FromEmailBox.Location = new System.Drawing.Point(96, 32);
			this.FromEmailBox.Name = "FromEmailBox";
			this.FromEmailBox.Size = new System.Drawing.Size(208, 20);
			this.FromEmailBox.TabIndex = 3;
			this.FromEmailBox.Text = "";
			// 
			// FromEmailLabel
			// 
			this.FromEmailLabel.Location = new System.Drawing.Point(8, 32);
			this.FromEmailLabel.Name = "FromEmailLabel";
			this.FromEmailLabel.Size = new System.Drawing.Size(80, 23);
			this.FromEmailLabel.TabIndex = 2;
			this.FromEmailLabel.Text = "Your email:";
			// 
			// FromNameBox
			// 
			this.FromNameBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.FromNameBox.Location = new System.Drawing.Point(96, 8);
			this.FromNameBox.Name = "FromNameBox";
			this.FromNameBox.Size = new System.Drawing.Size(208, 20);
			this.FromNameBox.TabIndex = 1;
			this.FromNameBox.Text = "";
			// 
			// FromNameLabel
			// 
			this.FromNameLabel.Location = new System.Drawing.Point(8, 8);
			this.FromNameLabel.Name = "FromNameLabel";
			this.FromNameLabel.Size = new System.Drawing.Size(80, 23);
			this.FromNameLabel.TabIndex = 0;
			this.FromNameLabel.Text = "Your name:";
			// 
			// ToNameBox
			// 
			this.ToNameBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.ToNameBox.Location = new System.Drawing.Point(96, 96);
			this.ToNameBox.Name = "ToNameBox";
			this.ToNameBox.Size = new System.Drawing.Size(208, 20);
			this.ToNameBox.TabIndex = 7;
			this.ToNameBox.Text = "";
			// 
			// ToNameLabel
			// 
			this.ToNameLabel.Location = new System.Drawing.Point(8, 96);
			this.ToNameLabel.Name = "ToNameLabel";
			this.ToNameLabel.Size = new System.Drawing.Size(80, 23);
			this.ToNameLabel.TabIndex = 6;
			this.ToNameLabel.Text = "To name:";
			// 
			// MailItemConfig
			// 
			this.AcceptButton = this.OkButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.CloseButton;
			this.ClientSize = new System.Drawing.Size(314, 193);
			this.Controls.Add(this.ToNameBox);
			this.Controls.Add(this.FromNameBox);
			this.Controls.Add(this.FromEmailBox);
			this.Controls.Add(this.SmtpBox);
			this.Controls.Add(this.ToEmailBox);
			this.Controls.Add(this.ToNameLabel);
			this.Controls.Add(this.FromNameLabel);
			this.Controls.Add(this.FromEmailLabel);
			this.Controls.Add(this.SmtpLabel);
			this.Controls.Add(this.CloseButton);
			this.Controls.Add(this.OkButton);
			this.Controls.Add(this.ToEmailLabel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "MailItemConfig";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Mail Plugin Configuration";
			this.TopMost = true;
			this.ResumeLayout(false);

		}
		#endregion

		private void CloseButton_Click(object sender, System.EventArgs e) {
			ResetDialog();
			this.DialogResult = DialogResult.Cancel;
		}

		private void OkButton_Click(object sender, System.EventArgs e) {
			_smtpServer = this.SmtpBox.Text;
			_nameFrom = this.FromNameBox.Text;
			_nameTo = this.ToNameBox.Text;
			_emailFrom = this.FromEmailBox.Text;
			_emailTo = this.ToEmailBox.Text;
			this.DialogResult = DialogResult.OK;
		}

		private void ResetDialog() {
			this.SmtpBox.Text = _smtpServer;
			this.FromNameBox.Text = _nameFrom;
			this.ToNameBox.Text = _nameTo;
			this.FromEmailBox.Text = _emailFrom;
			this.ToEmailBox.Text = _emailTo;
		}

		internal string SmtpServer {
			get { return _smtpServer; }
			set { _smtpServer = value; ResetDialog(); }
		}

		internal string NameFrom {
			get { return _nameFrom; }
			set { _nameFrom = value; ResetDialog(); }
		}

		internal string NameTo {
			get { return _nameTo; }
			set { _nameTo = value; ResetDialog(); }
		}

		internal string EmailFrom {
			get { return _emailFrom; }
			set { _emailFrom = value; ResetDialog(); }
		}

		internal string EmailTo {
			get { return _emailTo; }
			set { _emailTo = value; ResetDialog(); }
		}
	
	}

}
