/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PLine;
import processing.core.PMatrix;
import processing.core.PTriangle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PGraphics3D
extends PGraphics {
    static final int LIGHT_AMBIENT_R = 0;
    static final int LIGHT_AMBIENT_G = 1;
    static final int LIGHT_AMBIENT_B = 2;
    static final int LIGHT_DIFFUSE_R = 3;
    static final int LIGHT_DIFFUSE_G = 4;
    static final int LIGHT_DIFFUSE_B = 5;
    static final int LIGHT_SPECULAR_R = 6;
    static final int LIGHT_SPECULAR_G = 7;
    static final int LIGHT_SPECULAR_B = 8;
    static final int LIGHT_COLOR_COUNT = 9;
    static final int DEFAULT_LINES = 512;
    static final int DEFAULT_TRIANGLES = 256;
    static final int DEFAULT_TEXTURES = 3;
    private boolean lightingDependsOnVertexPosition;
    protected float[] tempLightingContribution;
    protected float[] worldNormal;
    protected float[] dv1;
    protected float[] dv2;
    protected float[] norm;
    protected boolean manipulatingCamera;
    protected PMatrix forwardTransform;
    protected PMatrix reverseTransform;
    protected int vertex_start;
    protected int vertex_end;
    protected int vertex_end_including_clip_verts;
    protected int[] vertex_order;
    protected int pathCount;
    protected int[] pathOffset;
    protected int[] pathLength;
    public PLine line;
    protected int[][] lines;
    protected int lineCount;
    public PTriangle triangle;
    protected int[][] triangles;
    protected float[][][] triangleColors;
    protected int triangleCount;
    public int shape_index;
    protected PImage[] textures;
    int texture_index;
    float[] sphereX;
    float[] sphereY;
    float[] sphereZ;

    public void resize(int n, int n2) {
        this.insideDrawWait();
        this.insideResize = true;
        this.width = n;
        this.height = n2;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / this.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.lightType = new int[8];
        this.lightPosition = new float[8][3];
        this.lightDiffuse = new float[8][3];
        this.lightNormal = new float[8][3];
        this.lightSpecular = new float[8][3];
        this.lightFalloffConstant = new float[8];
        this.lightFalloffLinear = new float[8];
        this.lightFalloffQuadratic = new float[8];
        this.lightSpotAngle = new float[8];
        this.lightSpotAngleCos = new float[8];
        this.lightSpotConcentration = new float[8];
        this.currentLightSpecular = new float[3];
        this.projection = new PMatrix();
        this.modelview = new PMatrix(32);
        this.modelviewInv = new PMatrix(32);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.camera = new PMatrix();
        this.cameraInv = new PMatrix();
        this.camera();
        this.perspective();
        this.insideResize = false;
    }

    protected void allocate() {
        this.pixelCount = this.width * this.height;
        this.pixels = new int[this.pixelCount];
        this.zbuffer = new float[this.pixelCount];
        if (this.mainDrawingSurface) {
            int n = 0;
            while (n < this.pixelCount) {
                this.pixels[n] = this.backgroundColor;
                ++n;
            }
            this.cm = new DirectColorModel(32, 0xFF0000, 65280, 255);
            this.mis = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.mis.setFullBufferUpdates(true);
            this.mis.setAnimated(true);
            this.image = Toolkit.getDefaultToolkit().createImage(this.mis);
        } else {
            int n = 0;
            while (n < this.pixelCount) {
                this.zbuffer[n] = Float.MAX_VALUE;
                ++n;
            }
        }
        this.stencil = new int[this.pixelCount];
        this.line = new PLine(this);
        this.triangle = new PTriangle(this);
    }

    public void beginDraw() {
        this.insideResizeWait();
        this.insideDraw = true;
        if (!this.defaultsInited) {
            this.defaults();
        }
        this.resetMatrix();
        this.vertexCount = 0;
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.lightCount = 0;
        this.lightingDependsOnVertexPosition = false;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.lineCount = 0;
        if (this.line != null) {
            this.line.reset();
        }
        this.pathCount = 0;
        this.triangleCount = 0;
        if (this.triangle != null) {
            this.triangle.reset();
        }
        this.vertex_start = 0;
        this.texture_index = 0;
        this.normal(0.0f, 0.0f, 1.0f);
    }

    public void endDraw() {
        if (this.hints[7]) {
            this.flush();
        }
        if (this.mis != null) {
            this.mis.newPixels(this.pixels, (ColorModel)this.cm, 0, this.width);
        }
        this.updatePixels();
        this.insideDraw = false;
    }

    protected void flush() {
        if (this.triangleCount > 0) {
            if (this.hints[7]) {
                this.depth_sort_triangles();
            }
            this.render_triangles();
        }
        if (this.lineCount > 0) {
            if (this.hints[7]) {
                this.depth_sort_lines();
            }
            this.render_lines();
        }
    }

    public void defaults() {
        super.defaults();
        this.manipulatingCamera = false;
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.perspective();
        this.textureMode(2);
        this.emissive(0.0f);
        this.specular(0.5f);
        this.shininess(1.0f);
    }

    public void beginShape(int n) {
        this.shape = n;
        ++this.shape_index;
        if (this.shape_index == -1) {
            this.shape_index = 0;
        }
        if (this.hints[7]) {
            this.vertex_start = this.vertexCount;
            this.vertex_end = 0;
        } else {
            this.vertexCount = 0;
            if (this.line != null) {
                this.line.reset();
            }
            this.lineCount = 0;
            this.pathCount = 0;
            if (this.triangle != null) {
                this.triangle.reset();
            }
            this.triangleCount = 0;
        }
        this.textureImage = null;
        this.splineVertexCount = 0;
        this.normalMode = 0;
        this.normalCount = 0;
    }

    public void normal(float f, float f2, float f3) {
        this.normalX = f;
        this.normalY = f2;
        this.normalZ = f3;
        if (this.shape != 0) {
            if (this.normalCount == 0) {
                int n = this.vertex_start;
                while (n < this.vertexCount) {
                    this.vertices[n][17] = this.normalX;
                    this.vertices[n][18] = this.normalY;
                    this.vertices[n][19] = this.normalZ;
                    ++n;
                }
            }
            ++this.normalCount;
            this.normalMode = this.normalCount == 1 ? 1 : 2;
        }
    }

    public void texture(PImage pImage) {
        this.textureImage = pImage;
        if (this.texture_index == this.textures.length - 1) {
            PImage[] pImageArray = new PImage[this.texture_index << 1];
            System.arraycopy(this.textures, 0, pImageArray, 0, this.texture_index);
            this.textures = pImageArray;
        }
        if (this.textures[0] != null) {
            ++this.texture_index;
        }
        this.textures[this.texture_index] = pImage;
    }

    public void vertex(float f, float f2) {
        this.setup_vertex(f, f2, 0.0f);
    }

    public void vertex(float f, float f2, float f3, float f4) {
        this.textureVertex(f3, f4);
        this.setup_vertex(f, f2, 0.0f);
    }

    public void vertex(float f, float f2, float f3) {
        this.setup_vertex(f, f2, f3);
    }

    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.textureVertex(f4, f5);
        this.setup_vertex(f, f2, f3);
    }

    protected void setup_vertex(float f, float f2, float f3) {
        Object[] objectArray;
        Object object;
        if (this.vertexCount == this.vertices.length) {
            object = new float[this.vertexCount << 1][36];
            System.arraycopy(this.vertices, 0, object, 0, this.vertexCount);
            this.vertices = (float[][])object;
            objectArray = new int[this.vertexCount << 1];
            System.arraycopy(this.vertex_order, 0, objectArray, 0, this.vertexCount);
            this.vertex_order = (int[])objectArray;
        }
        object = this.vertices[this.vertexCount];
        if (this.shape == 256 && this.vertexCount > 0 && this.abs((objectArray = this.vertices[this.vertexCount - 1])[9] - f) < 1.0E-4f && this.abs(objectArray[10] - f2) < 1.0E-4f && this.abs(objectArray[11] - f3) < 1.0E-4f) {
            return;
        }
        this.splineVertexCount = 0;
        object[9] = f;
        object[10] = f2;
        object[11] = f3;
        if (this.fill) {
            object[3] = this.fillR;
            object[4] = this.fillG;
            object[5] = this.fillB;
            object[6] = this.fillA;
            object[24] = this.ambientR;
            object[25] = this.ambientG;
            object[26] = this.ambientB;
            object[27] = this.specularR;
            object[28] = this.specularG;
            object[29] = this.specularB;
            object[30] = this.specularA;
            object[31] = this.shininess;
            object[32] = this.emissiveR;
            object[33] = this.emissiveG;
            object[34] = this.emissiveB;
        }
        if (this.stroke) {
            object[12] = this.strokeR;
            object[13] = this.strokeG;
            object[14] = this.strokeB;
            object[15] = this.strokeA;
            object[16] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            object[7] = this.textureU;
            object[8] = this.textureV;
        }
        object[17] = this.normalX;
        object[18] = this.normalY;
        object[19] = this.normalZ;
        object[35] = 0.0f;
        ++this.vertexCount;
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertex(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f);
    }

    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.splineVertexCount > 0) {
            float[] fArray = this.splineVertices[this.splineVertexCount - 1];
            this.splineVertex(fArray[9], fArray[10], fArray[11], true);
        } else if (this.vertexCount > 0) {
            float[] fArray = this.vertices[this.vertexCount - 1];
            this.splineVertex(fArray[9], fArray[10], fArray[11], true);
        } else {
            throw new RuntimeException("A call to vertex() must be used before bezierVertex()");
        }
        this.splineVertex(f, f2, f3, true);
        this.splineVertex(f4, f5, f6, true);
        this.splineVertex(f7, f8, f9, true);
    }

    public void endShape(int n) {
        int n2;
        this.vertex_end_including_clip_verts = this.vertex_end = this.vertexCount;
        if (this.vertexCount == 0) {
            this.shape = 0;
            return;
        }
        int n3 = this.vertex_start;
        while (n3 < this.vertex_end) {
            float[] fArray = this.vertices[n3];
            fArray[20] = this.modelview.m00 * fArray[9] + this.modelview.m01 * fArray[10] + this.modelview.m02 * fArray[11] + this.modelview.m03;
            fArray[21] = this.modelview.m10 * fArray[9] + this.modelview.m11 * fArray[10] + this.modelview.m12 * fArray[11] + this.modelview.m13;
            fArray[22] = this.modelview.m20 * fArray[9] + this.modelview.m21 * fArray[10] + this.modelview.m22 * fArray[11] + this.modelview.m23;
            fArray[23] = this.modelview.m30 * fArray[9] + this.modelview.m31 * fArray[10] + this.modelview.m32 * fArray[11] + this.modelview.m33;
            if (fArray[23] != 0.0f && fArray[23] != 1.0f) {
                fArray[20] = fArray[20] / fArray[23];
                fArray[21] = fArray[21] / fArray[23];
                fArray[22] = fArray[22] / fArray[23];
            }
            fArray[23] = 1.0f;
            ++n3;
        }
        n3 = 1;
        int n4 = 0;
        if (this.stroke) {
            switch (this.shape) {
                case 16: {
                    n4 = this.vertex_end;
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_path();
                        this.add_line(n2, n2);
                        ++n2;
                    }
                    break;
                }
                case 32: {
                    n2 = this.lineCount;
                    n4 = this.vertex_end - 1;
                    int n5 = 0;
                    if (this.shape == 32) {
                        n5 = 1;
                    }
                    n3 = n5 + 1;
                    if (this.shape != 32) {
                        this.add_path();
                    }
                    int n6 = this.vertex_start;
                    while (n6 < n4) {
                        if (this.shape == 32) {
                            this.add_path();
                        }
                        this.add_line(n6, n6 + 1);
                        n6 += n3;
                    }
                    if (n != 2) break;
                    this.add_line(n4, this.lines[n2][1]);
                    break;
                }
                case 64: {
                    n2 = this.vertex_start;
                    while (n2 < this.vertex_end - 2) {
                        this.add_path();
                        this.add_line(n2, n2 + 1);
                        this.add_line(n2 + 1, n2 + 2);
                        this.add_line(n2 + 2, n2);
                        n2 += 3;
                    }
                    break;
                }
                case 65: {
                    n4 = this.vertex_end - 1;
                    this.add_path();
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_line(n2, n2 + 1);
                        ++n2;
                    }
                    n4 = this.vertex_end - 2;
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_path();
                        this.add_line(n2, n2 + 2);
                        ++n2;
                    }
                    break;
                }
                case 66: {
                    n2 = this.vertex_start + 1;
                    while (n2 < this.vertex_end) {
                        this.add_path();
                        this.add_line(this.vertex_start, n2);
                        ++n2;
                    }
                    this.add_path();
                    n2 = this.vertex_start + 1;
                    while (n2 < this.vertex_end - 1) {
                        this.add_line(n2, n2 + 1);
                        ++n2;
                    }
                    this.add_line(this.vertex_end - 1, this.vertex_start + 1);
                    break;
                }
                case 128: {
                    n2 = this.vertex_start;
                    while (n2 < this.vertex_end) {
                        this.add_path();
                        this.add_line(n2, n2 + 1);
                        this.add_line(n2 + 1, n2 + 2);
                        this.add_line(n2 + 2, n2 + 3);
                        this.add_line(n2 + 3, n2);
                        n2 += 4;
                    }
                    break;
                }
                case 129: {
                    n2 = this.vertex_start;
                    while (n2 < this.vertex_end - 3) {
                        this.add_path();
                        this.add_line(n2, n2 + 2);
                        this.add_line(n2 + 2, n2 + 3);
                        this.add_line(n2 + 3, n2 + 1);
                        this.add_line(n2 + 1, n2);
                        n2 += 2;
                    }
                    break;
                }
                case 256: {
                    n4 = this.vertex_end - 1;
                    this.add_path();
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_line(n2, n2 + 1);
                        ++n2;
                    }
                    if (n != 2) break;
                    this.add_line(n4, this.vertex_start);
                    break;
                }
            }
        }
        if (this.fill) {
            switch (this.shape) {
                case 66: {
                    n4 = this.vertex_end - 1;
                    n2 = this.vertex_start + 1;
                    while (n2 < n4) {
                        this.add_triangle(this.vertex_start, n2, n2 + 1);
                        ++n2;
                    }
                    break;
                }
                case 64: 
                case 65: {
                    n4 = this.vertex_end - 2;
                    n3 = this.shape == 64 ? 3 : 1;
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        if (n2 % 2 == 0) {
                            this.add_triangle(n2, n2 + 2, n2 + 1);
                        } else {
                            this.add_triangle(n2, n2 + 1, n2 + 2);
                        }
                        n2 += n3;
                    }
                    break;
                }
                case 128: {
                    n4 = this.vertexCount - 3;
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_triangle(n2, n2 + 1, n2 + 2);
                        this.add_triangle(n2, n2 + 2, n2 + 3);
                        n2 += 4;
                    }
                    break;
                }
                case 129: {
                    n4 = this.vertexCount - 3;
                    n2 = this.vertex_start;
                    while (n2 < n4) {
                        this.add_triangle(n2, n2 + 2, n2 + 1);
                        this.add_triangle(n2 + 2, n2 + 3, n2 + 1);
                        n2 += 2;
                    }
                    break;
                }
                case 256: {
                    this.triangulate_polygon();
                    break;
                }
            }
        }
        if (this.lightCount > 0 && this.fill) {
            this.handle_lighting();
        } else {
            this.handle_no_lighting();
        }
        n2 = this.vertex_start;
        while (n2 < this.vertex_end_including_clip_verts) {
            float[] fArray = this.vertices[n2];
            float f = this.projection.m00 * fArray[20] + this.projection.m01 * fArray[21] + this.projection.m02 * fArray[22] + this.projection.m03 * fArray[23];
            float f2 = this.projection.m10 * fArray[20] + this.projection.m11 * fArray[21] + this.projection.m12 * fArray[22] + this.projection.m13 * fArray[23];
            float f3 = this.projection.m20 * fArray[20] + this.projection.m21 * fArray[21] + this.projection.m22 * fArray[22] + this.projection.m23 * fArray[23];
            float f4 = this.projection.m30 * fArray[20] + this.projection.m31 * fArray[21] + this.projection.m32 * fArray[22] + this.projection.m33 * fArray[23];
            if (f4 != 0.0f && f4 != 1.0f) {
                f /= f4;
                f2 /= f4;
                f3 /= f4;
            }
            fArray[0] = (float)this.width * (1.0f + f) / 2.0f;
            fArray[1] = (float)this.height * (1.0f + f2) / 2.0f;
            fArray[2] = (f3 + 1.0f) / 2.0f;
            ++n2;
        }
        if (!this.hints[7]) {
            if (this.fill) {
                this.render_triangles();
            }
            if (this.stroke) {
                this.render_lines();
            }
        }
        this.shape = 0;
    }

    protected final void add_path() {
        if (this.pathCount == this.pathOffset.length) {
            int[] nArray = new int[this.pathCount << 1];
            System.arraycopy(this.pathOffset, 0, nArray, 0, this.pathCount);
            this.pathOffset = nArray;
            int[] nArray2 = new int[this.pathCount << 1];
            System.arraycopy(this.pathLength, 0, nArray2, 0, this.pathCount);
            this.pathLength = nArray2;
        }
        this.pathOffset[this.pathCount] = this.lineCount;
        this.pathLength[this.pathCount] = 0;
        ++this.pathCount;
    }

    protected void add_line(int n, int n2) {
        this.add_line_with_clip(n, n2);
    }

    protected final void add_line_with_clip(int n, int n2) {
        float f = this.vertices[n][22];
        float f2 = this.vertices[n2][22];
        if (f > this.cameraNear) {
            if (f2 > this.cameraNear) {
                return;
            }
            int n3 = this.interpolate_clip_vertex(n, n2);
            this.add_line_no_clip(n3, n2);
            return;
        }
        if (f2 <= this.cameraNear) {
            this.add_line_no_clip(n, n2);
            return;
        }
        int n4 = this.interpolate_clip_vertex(n, n2);
        this.add_line_no_clip(n, n4);
    }

    protected final void add_line_no_clip(int n, int n2) {
        if (this.lineCount == this.lines.length) {
            int[][] nArray = new int[this.lineCount << 1][5];
            System.arraycopy(this.lines, 0, nArray, 0, this.lineCount);
            this.lines = nArray;
        }
        this.lines[this.lineCount][1] = n;
        this.lines[this.lineCount][2] = n2;
        this.lines[this.lineCount][0] = -1;
        this.lines[this.lineCount][3] = this.strokeCap | this.strokeJoin;
        this.lines[this.lineCount][4] = (int)(this.strokeWeight + 0.5f);
        ++this.lineCount;
        int n3 = this.pathCount - 1;
        this.pathLength[n3] = this.pathLength[n3] + 1;
    }

    protected void add_triangle(int n, int n2, int n3) {
        this.add_triangle_with_clip(n, n2, n3);
    }

    protected final void add_triangle_with_clip(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        this.cameraNear = -8.0f;
        if (this.vertices[n][22] > this.cameraNear) {
            bl = true;
            ++n7;
        }
        if (this.vertices[n2][22] > this.cameraNear) {
            bl2 = true;
            ++n7;
        }
        if (this.vertices[n3][22] > this.cameraNear) {
            ++n7;
        }
        if (n7 == 0) {
            this.add_triangle_no_clip(n, n2, n3);
            return;
        }
        if (n7 == 3) {
            return;
        }
        if (n7 == 2) {
            int n8;
            int n9;
            int n10;
            if (!bl) {
                n10 = n;
                n9 = n2;
                n8 = n3;
            } else if (!bl2) {
                n10 = n2;
                n9 = n;
                n8 = n3;
            } else {
                n10 = n3;
                n9 = n2;
                n8 = n;
            }
            int n11 = this.interpolate_clip_vertex(n10, n9);
            int n12 = this.interpolate_clip_vertex(n10, n8);
            this.add_triangle_no_clip(n10, n11, n12);
            return;
        }
        if (bl) {
            n6 = n3;
            n5 = n2;
            n4 = n;
        } else if (bl2) {
            n6 = n;
            n5 = n3;
            n4 = n2;
        } else {
            n6 = n;
            n5 = n2;
            n4 = n3;
        }
        int n13 = this.interpolate_clip_vertex(n6, n4);
        int n14 = this.interpolate_clip_vertex(n5, n4);
        this.add_triangle_no_clip(n6, n13, n5);
        this.add_triangle_no_clip(n5, n13, n14);
    }

    private final int interpolate_clip_vertex(int n, int n2) {
        float[] fArray;
        float[] fArray2;
        if (this.vertices[n][22] < this.vertices[n2][22]) {
            fArray2 = this.vertices[n2];
            fArray = this.vertices[n];
        } else {
            fArray2 = this.vertices[n];
            fArray = this.vertices[n2];
        }
        float f = fArray2[22];
        float f2 = fArray[22];
        float f3 = f - f2;
        if (f3 == 0.0f) {
            return n;
        }
        float f4 = (this.cameraNear - f2) / f3;
        float f5 = 1.0f - f4;
        this.vertex(f4 * fArray2[9] + f5 * fArray[9], f4 * fArray2[10] + f5 * fArray[10], f4 * fArray2[11] + f5 * fArray[11]);
        int n3 = this.vertexCount - 1;
        ++this.vertex_end_including_clip_verts;
        float[] fArray3 = this.vertices[n3];
        fArray3[0] = f4 * fArray2[0] + f5 * fArray[0];
        fArray3[1] = f4 * fArray2[1] + f5 * fArray[1];
        fArray3[2] = f4 * fArray2[2] + f5 * fArray[2];
        fArray3[20] = f4 * fArray2[20] + f5 * fArray[20];
        fArray3[21] = f4 * fArray2[21] + f5 * fArray[21];
        fArray3[22] = f4 * fArray2[22] + f5 * fArray[22];
        fArray3[23] = f4 * fArray2[23] + f5 * fArray[23];
        fArray3[3] = f4 * fArray2[3] + f5 * fArray[3];
        fArray3[4] = f4 * fArray2[4] + f5 * fArray[4];
        fArray3[5] = f4 * fArray2[5] + f5 * fArray[5];
        fArray3[6] = f4 * fArray2[6] + f5 * fArray[6];
        fArray3[7] = f4 * fArray2[7] + f5 * fArray[7];
        fArray3[8] = f4 * fArray2[8] + f5 * fArray[8];
        fArray3[12] = f4 * fArray2[12] + f5 * fArray[12];
        fArray3[13] = f4 * fArray2[13] + f5 * fArray[13];
        fArray3[14] = f4 * fArray2[14] + f5 * fArray[14];
        fArray3[15] = f4 * fArray2[15] + f5 * fArray[15];
        fArray3[17] = f4 * fArray2[17] + f5 * fArray[17];
        fArray3[18] = f4 * fArray2[18] + f5 * fArray[18];
        fArray3[19] = f4 * fArray2[19] + f5 * fArray[19];
        fArray3[16] = f4 * fArray2[16] + f5 * fArray[16];
        fArray3[24] = f4 * fArray2[24] + f5 * fArray[24];
        fArray3[25] = f4 * fArray2[25] + f5 * fArray[25];
        fArray3[26] = f4 * fArray2[26] + f5 * fArray[26];
        fArray3[27] = f4 * fArray2[27] + f5 * fArray[27];
        fArray3[28] = f4 * fArray2[28] + f5 * fArray[28];
        fArray3[29] = f4 * fArray2[29] + f5 * fArray[29];
        fArray3[30] = f4 * fArray2[30] + f5 * fArray[30];
        fArray3[32] = f4 * fArray2[32] + f5 * fArray[32];
        fArray3[33] = f4 * fArray2[33] + f5 * fArray[33];
        fArray3[34] = f4 * fArray2[34] + f5 * fArray[34];
        fArray3[31] = f4 * fArray2[31] + f5 * fArray[31];
        fArray3[35] = 0.0f;
        return n3;
    }

    protected final void add_triangle_no_clip(int n, int n2, int n3) {
        if (this.triangleCount == this.triangles.length) {
            int[][] nArray = new int[this.triangleCount << 1][5];
            System.arraycopy(this.triangles, 0, nArray, 0, this.triangleCount);
            this.triangles = nArray;
            float[][][] fArray = new float[this.triangleCount << 1][3][8];
            System.arraycopy(this.triangleColors, 0, fArray, 0, this.triangleCount);
            this.triangleColors = fArray;
        }
        this.triangles[this.triangleCount][1] = n;
        this.triangles[this.triangleCount][2] = n2;
        this.triangles[this.triangleCount][3] = n3;
        this.triangles[this.triangleCount][4] = this.textureImage == null ? -1 : this.texture_index;
        this.triangles[this.triangleCount][0] = this.shape_index;
        ++this.triangleCount;
    }

    protected void depth_sort_triangles() {
        this.depth_sort_triangles_internal(0, this.triangleCount - 1);
    }

    protected void depth_sort_triangles_internal(int n, int n2) {
        int n3 = (n + n2) / 2;
        this.depth_sort_triangles_swap(n3, n2);
        int n4 = this.depth_sort_triangles_partition(n - 1, n2);
        this.depth_sort_triangles_swap(n4, n2);
        if (n4 - n > 1) {
            this.depth_sort_triangles_internal(n, n4 - 1);
        }
        if (n2 - n4 > 1) {
            this.depth_sort_triangles_internal(n4 + 1, n2);
        }
    }

    protected int depth_sort_triangles_partition(int n, int n2) {
        int n3 = n2;
        while (true) {
            if (this.depth_sort_triangles_compare(++n, n3) < 0.0f) {
                continue;
            }
            while (n2 != 0 && this.depth_sort_triangles_compare(--n2, n3) > 0.0f) {
            }
            this.depth_sort_triangles_swap(n, n2);
            if (n >= n2) break;
        }
        this.depth_sort_triangles_swap(n, n2);
        return n;
    }

    protected void depth_sort_triangles_swap(int n, int n2) {
        int[] nArray = this.triangles[n];
        this.triangles[n] = this.triangles[n2];
        this.triangles[n2] = nArray;
        float[][] fArray = this.triangleColors[n];
        this.triangleColors[n] = this.triangleColors[n2];
        this.triangleColors[n2] = fArray;
    }

    protected float depth_sort_triangles_compare(int n, int n2) {
        if (Float.isNaN(this.vertices[this.triangles[n][1]][2]) || Float.isNaN(this.vertices[this.triangles[n][2]][2]) || Float.isNaN(this.vertices[this.triangles[n][3]][2]) || Float.isNaN(this.vertices[this.triangles[n2][1]][2]) || Float.isNaN(this.vertices[this.triangles[n2][2]][2]) || Float.isNaN(this.vertices[this.triangles[n2][3]][2])) {
            throw new RuntimeException("nan triangle");
        }
        return this.vertices[this.triangles[n2][1]][2] + this.vertices[this.triangles[n2][2]][2] + this.vertices[this.triangles[n2][3]][2] - (this.vertices[this.triangles[n][1]][2] + this.vertices[this.triangles[n][2]][2] + this.vertices[this.triangles[n][3]][2]);
    }

    protected void render_triangles() {
        if (this.raw != null) {
            this.raw.colorMode(1, 1.0f);
            this.raw.noStroke();
            this.raw.beginShape(64);
        }
        int n = 0;
        while (n < this.triangleCount) {
            float[] fArray = this.vertices[this.triangles[n][1]];
            float[] fArray2 = this.vertices[this.triangles[n][2]];
            float[] fArray3 = this.vertices[this.triangles[n][3]];
            int n2 = this.triangles[n][4];
            int n3 = this.triangles[n][0];
            this.triangle.reset();
            float f = this.min(1.0f, this.triangleColors[n][0][0] + this.triangleColors[n][0][4]);
            float f2 = this.min(1.0f, this.triangleColors[n][0][1] + this.triangleColors[n][0][5]);
            float f3 = this.min(1.0f, this.triangleColors[n][0][2] + this.triangleColors[n][0][6]);
            float f4 = this.min(1.0f, this.triangleColors[n][1][0] + this.triangleColors[n][1][4]);
            float f5 = this.min(1.0f, this.triangleColors[n][1][1] + this.triangleColors[n][1][5]);
            float f6 = this.min(1.0f, this.triangleColors[n][1][2] + this.triangleColors[n][1][6]);
            float f7 = this.min(1.0f, this.triangleColors[n][2][0] + this.triangleColors[n][2][4]);
            float f8 = this.min(1.0f, this.triangleColors[n][2][1] + this.triangleColors[n][2][5]);
            float f9 = this.min(1.0f, this.triangleColors[n][2][2] + this.triangleColors[n][2][6]);
            if (n2 > -1 && this.textures[n2] != null) {
                this.triangle.setTexture(this.textures[n2]);
                this.triangle.setUV(fArray[7], fArray[8], fArray2[7], fArray2[8], fArray3[7], fArray3[8]);
            }
            this.triangle.setIntensities(f, f2, f3, fArray[6], f4, f5, f6, fArray2[6], f7, f8, f9, fArray3[6]);
            this.triangle.setVertices(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2]);
            this.triangle.setIndex(n3);
            this.triangle.render();
            if (this.raw != null) {
                if (this.raw instanceof PGraphics3D) {
                    if (fArray[23] != 0.0f && fArray2[23] != 0.0f && fArray3[23] != 0.0f) {
                        this.raw.fill(f, f2, f3, fArray[6]);
                        this.raw.vertex(fArray[20] / fArray[23], fArray[21] / fArray[23], fArray[22] / fArray[23]);
                        this.raw.fill(f4, f5, f6, fArray2[6]);
                        this.raw.vertex(fArray2[20] / fArray2[23], fArray2[21] / fArray2[23], fArray2[22] / fArray2[23]);
                        this.raw.fill(f7, f8, f9, fArray3[6]);
                        this.raw.vertex(fArray3[20] / fArray3[23], fArray3[21] / fArray3[23], fArray3[22] / fArray3[23]);
                    }
                } else {
                    this.raw.fill(f, f2, f3, fArray[6]);
                    this.raw.vertex(fArray[0], fArray[1]);
                    this.raw.fill(f4, f5, f6, fArray2[6]);
                    this.raw.vertex(fArray2[0], fArray2[1]);
                    this.raw.fill(f7, f8, f9, fArray3[6]);
                    this.raw.vertex(fArray3[0], fArray3[1]);
                }
            }
            ++n;
        }
        if (this.raw != null) {
            this.raw.endShape();
        }
    }

    protected void depth_sort_lines() {
    }

    protected void render_lines() {
        if (this.raw != null) {
            this.raw.colorMode(1, 1.0f);
            this.raw.noFill();
            this.raw.beginShape(32);
        }
        int n = 0;
        while (n < this.lineCount) {
            float[] fArray = this.vertices[this.lines[n][1]];
            float[] fArray2 = this.vertices[this.lines[n][2]];
            int n2 = this.lines[n][0];
            this.line.reset();
            this.line.setIntensities(fArray[12], fArray[13], fArray[14], fArray[15], fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
            this.line.setVertices(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2]);
            if (this.raw != null) {
                if (this.raw instanceof PGraphics3D) {
                    if (fArray[23] != 0.0f && fArray2[23] != 0.0f) {
                        this.raw.stroke(fArray[12], fArray[13], fArray[14], fArray[15]);
                        this.raw.vertex(fArray[20] / fArray[23], fArray[21] / fArray[23], fArray[22] / fArray[23]);
                        this.raw.stroke(fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
                        this.raw.vertex(fArray2[20] / fArray2[23], fArray2[21] / fArray2[23], fArray2[22] / fArray2[23]);
                    }
                } else {
                    this.raw.stroke(fArray[12], fArray[13], fArray[14], fArray[15]);
                    this.raw.vertex(fArray[0], fArray[1]);
                    this.raw.stroke(fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
                    this.raw.vertex(fArray2[0], fArray2[1]);
                }
            }
            this.line.setIndex(n2);
            this.line.draw();
            ++n;
        }
        if (this.raw != null) {
            this.raw.endShape();
        }
    }

    private final void triangulate_polygon() {
        float[] fArray;
        float[] fArray2;
        int n;
        int n2;
        int n3 = 9;
        int n4 = 10;
        float f = 0.0f;
        int n5 = this.vertex_end - 1;
        int n6 = this.vertex_start;
        while (n6 < this.vertex_end) {
            f += this.vertices[n6][n3] * this.vertices[n5][n4] - this.vertices[n5][n3] * this.vertices[n6][n4];
            n5 = n6++;
        }
        if (f == 0.0f) {
            n5 = 0;
            n6 = 0;
            n2 = this.vertex_start;
            while (n2 < this.vertex_end) {
                if (this.vertices[n2][9] != 0.0f) {
                    n5 = 1;
                }
                if (this.vertices[n2][10] != 0.0f) {
                    n6 = 1;
                }
                ++n2;
            }
            if (n5 != 0 && n6 == 0) {
                n4 = 11;
            } else if (n5 == 0 && n6 != 0) {
                n3 = 10;
                n4 = 11;
            } else {
                return;
            }
            n2 = this.vertex_end - 1;
            n = this.vertex_start;
            while (n < this.vertex_end) {
                f += this.vertices[n][n3] * this.vertices[n2][n4] - this.vertices[n2][n3] * this.vertices[n][n4];
                n2 = n++;
            }
        }
        if (this.abs((fArray2 = this.vertices[this.vertex_start])[9] - (fArray = this.vertices[this.vertex_end - 1])[9]) < 1.0E-4f && this.abs(fArray2[10] - fArray[10]) < 1.0E-4f && this.abs(fArray2[11] - fArray[11]) < 1.0E-4f) {
            --this.vertex_end;
        }
        n2 = 0;
        if (f > 0.0f) {
            n = this.vertex_start;
            while (n < this.vertex_end) {
                n2 = n - this.vertex_start;
                this.vertex_order[n2] = n++;
            }
        } else {
            n = this.vertex_start;
            while (n < this.vertex_end) {
                n2 = n - this.vertex_start;
                this.vertex_order[n2] = this.vertex_end - 1 - n2;
                ++n;
            }
        }
        n = this.vertex_end - this.vertex_start;
        int n7 = 2 * n;
        int n8 = 0;
        int n9 = n - 1;
        while (n > 2) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            int n10;
            boolean bl = true;
            if (n7-- <= 0) break;
            int n11 = n9;
            if (n <= n11) {
                n11 = 0;
            }
            if (n <= (n9 = n11 + 1)) {
                n9 = 0;
            }
            if (n <= (n10 = n9 + 1)) {
                n10 = 0;
            }
            if (1.0E-4f > ((f7 = -this.vertices[this.vertex_order[n9]][n3]) - (f6 = -this.vertices[this.vertex_order[n11]][n3])) * ((f5 = this.vertices[this.vertex_order[n10]][n4]) - (f4 = this.vertices[this.vertex_order[n11]][n4])) - ((f3 = this.vertices[this.vertex_order[n9]][n4]) - f4) * ((f2 = -this.vertices[this.vertex_order[n10]][n3]) - f6)) continue;
            int n12 = 0;
            while (n12 < n) {
                if (n12 != n11 && n12 != n9 && n12 != n10) {
                    float f8 = -this.vertices[this.vertex_order[n12]][n3];
                    float f9 = this.vertices[this.vertex_order[n12]][n4];
                    float f10 = f2 - f7;
                    float f11 = f5 - f3;
                    float f12 = f6 - f2;
                    float f13 = f4 - f5;
                    float f14 = f7 - f6;
                    float f15 = f3 - f4;
                    float f16 = f8 - f6;
                    float f17 = f9 - f4;
                    float f18 = f8 - f7;
                    float f19 = f9 - f3;
                    float f20 = f8 - f2;
                    float f21 = f9 - f5;
                    float f22 = f10 * f19 - f11 * f18;
                    float f23 = f14 * f17 - f15 * f16;
                    float f24 = f12 * f21 - f13 * f20;
                    if (f22 >= 0.0f && f24 >= 0.0f && f23 >= 0.0f) {
                        bl = false;
                    }
                }
                ++n12;
            }
            if (!bl) continue;
            this.add_triangle(this.vertex_order[n11], this.vertex_order[n9], this.vertex_order[n10]);
            ++n8;
            n12 = n9;
            int n13 = n9 + 1;
            while (n13 < n) {
                this.vertex_order[n12] = this.vertex_order[n13];
                ++n12;
                ++n13;
            }
            n7 = 2 * --n;
        }
    }

    private final void toWorldNormal(float f, float f2, float f3, float[] fArray) {
        fArray[0] = this.modelviewInv.m00 * f + this.modelviewInv.m10 * f2 + this.modelviewInv.m20 * f3 + this.modelviewInv.m30;
        fArray[1] = this.modelviewInv.m01 * f + this.modelviewInv.m11 * f2 + this.modelviewInv.m21 * f3 + this.modelviewInv.m31;
        fArray[2] = this.modelviewInv.m02 * f + this.modelviewInv.m12 * f2 + this.modelviewInv.m22 * f3 + this.modelviewInv.m32;
        fArray[3] = this.modelviewInv.m03 * f + this.modelviewInv.m13 * f2 + this.modelviewInv.m23 * f3 + this.modelviewInv.m33;
        if (fArray[3] != 0.0f && fArray[3] != 1.0f) {
            fArray[0] = fArray[0] / fArray[3];
            fArray[1] = fArray[1] / fArray[3];
            fArray[2] = fArray[2] / fArray[3];
        }
        fArray[3] = 1.0f;
        float f4 = this.mag(fArray[0], fArray[1], fArray[2]);
        if (f4 != 0.0f && f4 != 1.0f) {
            fArray[0] = fArray[0] / f4;
            fArray[1] = fArray[1] / f4;
            fArray[2] = fArray[2] / f4;
        }
    }

    private final void calc_lighting_contribution(int n, float[] fArray) {
        this.calc_lighting_contribution(n, fArray, false);
    }

    private final void calc_lighting_contribution(int n, float[] fArray, boolean bl) {
        float f;
        float f2;
        float f3;
        float[] fArray2 = this.vertices[n];
        float f4 = fArray2[27];
        float f5 = fArray2[28];
        float f6 = fArray2[29];
        float f7 = fArray2[20];
        float f8 = fArray2[21];
        float f9 = fArray2[22];
        float f10 = fArray2[31];
        if (!bl) {
            this.toWorldNormal(fArray2[17], fArray2[18], fArray2[19], this.worldNormal);
            f3 = this.worldNormal[0];
            f2 = this.worldNormal[1];
            f = this.worldNormal[2];
        } else {
            f3 = fArray2[17];
            f2 = fArray2[18];
            f = fArray2[19];
        }
        float f11 = this.dot(f3, f2, f, -f7, -f8, -f9);
        if (f11 < 0.0f) {
            f3 = -f3;
            f2 = -f2;
            f = -f;
        }
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = 0.0f;
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 0.0f;
        int n2 = 0;
        while (n2 < this.lightCount) {
            block17: {
                float f12;
                float f13;
                float f14;
                float f15;
                float f16;
                float f17;
                float f18;
                block19: {
                    block20: {
                        float f19;
                        block18: {
                            block16: {
                                f18 = this.lightFalloffConstant[n2];
                                f17 = 1.0f;
                                if (this.lightType[n2] != 0) break block16;
                                if (this.lightFalloffQuadratic[n2] != 0.0f || this.lightFalloffLinear[n2] != 0.0f) {
                                    f16 = this.mag(this.lightPosition[n2][0] - f7, this.lightPosition[n2][1] - f8, this.lightPosition[n2][2] - f9);
                                    f18 += this.lightFalloffQuadratic[n2] * f16 + this.lightFalloffLinear[n2] * PGraphics3D.sqrt(f16);
                                }
                                if (f18 == 0.0f) {
                                    f18 = 1.0f;
                                }
                                fArray[0] = fArray[0] + this.lightDiffuse[n2][0] / f18;
                                fArray[1] = fArray[1] + this.lightDiffuse[n2][1] / f18;
                                fArray[2] = fArray[2] + this.lightDiffuse[n2][2] / f18;
                                break block17;
                            }
                            f19 = 0.0f;
                            f15 = 0.0f;
                            if (this.lightType[n2] != 1) break block18;
                            f16 = -this.lightNormal[n2][0];
                            f14 = -this.lightNormal[n2][1];
                            f13 = -this.lightNormal[n2][2];
                            f18 = 1.0f;
                            f15 = f3 * f16 + f2 * f14 + f * f13;
                            if (!(f15 <= 0.0f)) break block19;
                            break block17;
                        }
                        f16 = this.lightPosition[n2][0] - f7;
                        f14 = this.lightPosition[n2][1] - f8;
                        f13 = this.lightPosition[n2][2] - f9;
                        f12 = this.mag(f16, f14, f13);
                        if (f12 != 0.0f) {
                            f16 /= f12;
                            f14 /= f12;
                            f13 /= f12;
                        }
                        if ((f15 = f3 * f16 + f2 * f14 + f * f13) <= 0.0f) break block17;
                        if (this.lightType[n2] != 3) break block20;
                        f19 = -(this.lightNormal[n2][0] * f16 + this.lightNormal[n2][1] * f14 + this.lightNormal[n2][2] * f13);
                        if (f19 <= this.lightSpotAngleCos[n2]) break block17;
                        f17 = this.pow(f19, this.lightSpotConcentration[n2]);
                    }
                    if (this.lightFalloffQuadratic[n2] != 0.0f || this.lightFalloffLinear[n2] != 0.0f) {
                        f18 += this.lightFalloffQuadratic[n2] * f12 + this.lightFalloffLinear[n2] * PGraphics3D.sqrt(f12);
                    }
                }
                if (f18 == 0.0f) {
                    f18 = 1.0f;
                }
                f12 = f15 * f17 / f18;
                fArray[3] = fArray[3] + this.lightDiffuse[n2][0] * f12;
                fArray[4] = fArray[4] + this.lightDiffuse[n2][1] * f12;
                fArray[5] = fArray[5] + this.lightDiffuse[n2][2] * f12;
                if ((f4 > 0.0f || f5 > 0.0f || f6 > 0.0f) && (this.lightSpecular[n2][0] > 0.0f || this.lightSpecular[n2][1] > 0.0f || this.lightSpecular[n2][2] > 0.0f)) {
                    float f20;
                    float f21;
                    float f22;
                    float f23;
                    float f24 = this.mag(f7, f8, f9);
                    if (f24 != 0.0f) {
                        f7 /= f24;
                        f8 /= f24;
                        f9 /= f24;
                    }
                    if ((f24 = this.mag(f23 = f16 - f7, f22 = f14 - f8, f21 = f13 - f9)) != 0.0f) {
                        f23 /= f24;
                        f22 /= f24;
                        f21 /= f24;
                    }
                    if ((f20 = f23 * f3 + f22 * f2 + f21 * f) > 0.0f) {
                        f20 = this.pow(f20, f10);
                        f12 = f20 * f17 / f18;
                        fArray[6] = fArray[6] + this.lightSpecular[n2][0] * f12;
                        fArray[7] = fArray[7] + this.lightSpecular[n2][1] * f12;
                        fArray[8] = fArray[8] + this.lightSpecular[n2][2] * f12;
                    }
                }
            }
            ++n2;
        }
    }

    private final void apply_lighting_contribution(int n, float[] fArray) {
        float[] fArray2 = this.vertices[n];
        fArray2[3] = this.min(1.0f, fArray2[32] + fArray2[24] * fArray[0] + fArray2[3] * fArray[3]);
        fArray2[4] = this.min(1.0f, fArray2[33] + fArray2[25] * fArray[1] + fArray2[4] * fArray[4]);
        fArray2[5] = this.min(1.0f, fArray2[34] + fArray2[26] * fArray[2] + fArray2[5] * fArray[5]);
        fArray2[6] = this.min(1.0f, fArray2[6]);
        fArray2[27] = this.min(1.0f, fArray2[27] * fArray[6]);
        fArray2[28] = this.min(1.0f, fArray2[28] * fArray[7]);
        fArray2[29] = this.min(1.0f, fArray2[29] * fArray[8]);
        fArray2[30] = this.min(1.0f, fArray2[30]);
        fArray2[35] = 1.0f;
    }

    private final void light_vertex_always(int n, float[] fArray) {
        this.calc_lighting_contribution(n, fArray);
        this.apply_lighting_contribution(n, fArray);
    }

    private final void light_vertex_if_not_already_lit(int n, float[] fArray) {
        if (this.vertices[n][35] == 0.0f) {
            this.light_vertex_always(n, fArray);
        }
    }

    private final void copy_prelit_vertex_color_to_triangle(int n, int n2, int n3) {
        float[] fArray = this.triangleColors[n][n3];
        float[] fArray2 = this.vertices[n2];
        fArray[0] = fArray2[3];
        fArray[1] = fArray2[4];
        fArray[2] = fArray2[5];
        fArray[3] = fArray2[6];
        fArray[4] = fArray2[27];
        fArray[5] = fArray2[28];
        fArray[6] = fArray2[29];
        fArray[7] = fArray2[30];
    }

    private final void copy_vertex_color_to_triangle(int n, int n2, int n3, float[] fArray) {
        float[] fArray2 = this.triangleColors[n][n3];
        float[] fArray3 = this.vertices[n2];
        fArray2[0] = this.min(1.0f, fArray3[32] + fArray3[24] * fArray[0] + fArray3[3] * fArray[3]);
        fArray2[1] = this.min(1.0f, fArray3[33] + fArray3[25] * fArray[1] + fArray3[4] * fArray[4]);
        fArray2[2] = this.min(1.0f, fArray3[34] + fArray3[26] * fArray[2] + fArray3[5] * fArray[5]);
        fArray2[3] = this.min(1.0f, fArray3[6]);
        fArray2[4] = this.min(1.0f, fArray3[27] * fArray[6]);
        fArray2[5] = this.min(1.0f, fArray3[28] * fArray[7]);
        fArray2[6] = this.min(1.0f, fArray3[29] * fArray[8]);
        fArray2[7] = this.min(1.0f, fArray3[30]);
    }

    private final void light_triangle(int n, float[] fArray) {
        int n2 = this.triangles[n][1];
        this.copy_vertex_color_to_triangle(n, n2, 0, fArray);
        n2 = this.triangles[n][2];
        this.copy_vertex_color_to_triangle(n, n2, 1, fArray);
        n2 = this.triangles[n][3];
        this.copy_vertex_color_to_triangle(n, n2, 2, fArray);
    }

    private final void crossProduct(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[1] * fArray2[2] - fArray[2] * fArray2[1];
        fArray3[1] = fArray[2] * fArray2[0] - fArray[0] * fArray2[2];
        fArray3[2] = fArray[0] * fArray2[1] - fArray[1] * fArray2[0];
    }

    private final void light_triangle(int n) {
        if (this.normalMode == 2) {
            int n2 = this.triangles[n][1];
            this.light_vertex_if_not_already_lit(n2, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(n, n2, 0);
            n2 = this.triangles[n][2];
            this.light_vertex_if_not_already_lit(n2, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(n, n2, 1);
            n2 = this.triangles[n][3];
            this.light_vertex_if_not_already_lit(n2, this.tempLightingContribution);
            this.copy_prelit_vertex_color_to_triangle(n, n2, 2);
        } else if (!this.lightingDependsOnVertexPosition) {
            int n3 = this.triangles[n][1];
            int n4 = this.triangles[n][2];
            int n5 = this.triangles[n][3];
            this.dv1[0] = this.vertices[n4][20] - this.vertices[n3][20];
            this.dv1[1] = this.vertices[n4][21] - this.vertices[n3][21];
            this.dv1[2] = this.vertices[n4][22] - this.vertices[n3][22];
            this.dv2[0] = this.vertices[n5][20] - this.vertices[n3][20];
            this.dv2[1] = this.vertices[n5][21] - this.vertices[n3][21];
            this.dv2[2] = this.vertices[n5][22] - this.vertices[n3][22];
            this.crossProduct(this.dv1, this.dv2, this.norm);
            float f = this.mag(this.norm[0], this.norm[1], this.norm[2]);
            if (f != 0.0f && f != 1.0f) {
                this.norm[0] = this.norm[0] / f;
                this.norm[1] = this.norm[1] / f;
                this.norm[2] = this.norm[2] / f;
            }
            this.vertices[n3][17] = this.norm[0];
            this.vertices[n3][18] = this.norm[1];
            this.vertices[n3][19] = this.norm[2];
            this.calc_lighting_contribution(n3, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(n, n3, 0, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(n, n4, 1, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(n, n5, 2, this.tempLightingContribution);
        } else if (this.normalMode == 1) {
            int n6 = this.triangles[n][1];
            this.vertices[n6][17] = this.vertices[this.vertex_start][17];
            this.vertices[n6][18] = this.vertices[this.vertex_start][18];
            this.vertices[n6][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(n6, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(n, n6, 0, this.tempLightingContribution);
            n6 = this.triangles[n][2];
            this.vertices[n6][17] = this.vertices[this.vertex_start][17];
            this.vertices[n6][18] = this.vertices[this.vertex_start][18];
            this.vertices[n6][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(n6, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(n, n6, 1, this.tempLightingContribution);
            n6 = this.triangles[n][3];
            this.vertices[n6][17] = this.vertices[this.vertex_start][17];
            this.vertices[n6][18] = this.vertices[this.vertex_start][18];
            this.vertices[n6][19] = this.vertices[this.vertex_start][19];
            this.calc_lighting_contribution(n6, this.tempLightingContribution);
            this.copy_vertex_color_to_triangle(n, n6, 2, this.tempLightingContribution);
        } else {
            int n7 = this.triangles[n][1];
            int n8 = this.triangles[n][2];
            int n9 = this.triangles[n][3];
            this.dv1[0] = this.vertices[n8][20] - this.vertices[n7][20];
            this.dv1[1] = this.vertices[n8][21] - this.vertices[n7][21];
            this.dv1[2] = this.vertices[n8][22] - this.vertices[n7][22];
            this.dv2[0] = this.vertices[n9][20] - this.vertices[n7][20];
            this.dv2[1] = this.vertices[n9][21] - this.vertices[n7][21];
            this.dv2[2] = this.vertices[n9][22] - this.vertices[n7][22];
            this.crossProduct(this.dv1, this.dv2, this.norm);
            float f = this.mag(this.norm[0], this.norm[1], this.norm[2]);
            if (f != 0.0f && f != 1.0f) {
                this.norm[0] = this.norm[0] / f;
                this.norm[1] = this.norm[1] / f;
                this.norm[2] = this.norm[2] / f;
            }
            this.vertices[n7][17] = this.norm[0];
            this.vertices[n7][18] = this.norm[1];
            this.vertices[n7][19] = this.norm[2];
            this.calc_lighting_contribution(n7, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(n, n7, 0, this.tempLightingContribution);
            this.vertices[n8][17] = this.norm[0];
            this.vertices[n8][18] = this.norm[1];
            this.vertices[n8][19] = this.norm[2];
            this.calc_lighting_contribution(n8, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(n, n8, 1, this.tempLightingContribution);
            this.vertices[n9][17] = this.norm[0];
            this.vertices[n9][18] = this.norm[1];
            this.vertices[n9][19] = this.norm[2];
            this.calc_lighting_contribution(n9, this.tempLightingContribution, true);
            this.copy_vertex_color_to_triangle(n, n9, 2, this.tempLightingContribution);
        }
    }

    protected void handle_lighting() {
        if (!this.lightingDependsOnVertexPosition && this.normalMode == 1) {
            this.calc_lighting_contribution(this.vertex_start, this.tempLightingContribution);
            int n = 0;
            while (n < this.triangleCount) {
                this.light_triangle(n, this.tempLightingContribution);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.triangleCount) {
                this.light_triangle(n);
                ++n;
            }
        }
    }

    protected void handle_no_lighting() {
        int n = 0;
        while (n < this.triangleCount) {
            int n2 = this.triangles[n][1];
            this.copy_prelit_vertex_color_to_triangle(n, n2, 0);
            n2 = this.triangles[n][2];
            this.copy_prelit_vertex_color_to_triangle(n, n2, 1);
            n2 = this.triangles[n][3];
            this.copy_prelit_vertex_color_to_triangle(n, n2, 2);
            ++n;
        }
    }

    public void point(float f, float f2) {
        this.point(f, f2, 0.0f);
    }

    public void point(float f, float f2, float f3) {
        this.beginShape(32);
        this.vertex(f, f2, f3);
        this.vertex(f + 1.0E-4f, f2 + 1.0E-4f, f3);
        this.endShape();
    }

    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(64);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.endShape();
    }

    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(128);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(f, f2);
        this.vertex(f3, f4);
        this.vertex(f5, f6);
        this.vertex(f7, f8);
        this.endShape();
    }

    public void box(float f) {
        this.box(f, f, f);
    }

    public void box(float f, float f2, float f3) {
        float f4 = -f / 2.0f;
        float f5 = f / 2.0f;
        float f6 = -f2 / 2.0f;
        float f7 = f2 / 2.0f;
        float f8 = -f3 / 2.0f;
        float f9 = f3 / 2.0f;
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        this.beginShape(128);
        this.normal(0.0f, 0.0f, 1.0f);
        this.vertex(f4, f6, f8);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f4, f7, f8);
        this.normal(1.0f, 0.0f, 0.0f);
        this.vertex(f5, f6, f8);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f7, f9);
        this.vertex(f5, f7, f8);
        this.normal(0.0f, 0.0f, -1.0f);
        this.vertex(f5, f6, f9);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f7, f9);
        this.vertex(f5, f7, f9);
        this.normal(-1.0f, 0.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f4, f6, f8);
        this.vertex(f4, f7, f8);
        this.vertex(f4, f7, f9);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(f4, f6, f9);
        this.vertex(f5, f6, f9);
        this.vertex(f5, f6, f8);
        this.vertex(f4, f6, f8);
        this.normal(0.0f, -1.0f, 0.0f);
        this.vertex(f4, f7, f8);
        this.vertex(f5, f7, f8);
        this.vertex(f5, f7, f9);
        this.vertex(f4, f7, f9);
        this.endShape();
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void sphereDetail(int n) {
        float f;
        if (n < 3) {
            n = 3;
        }
        if (n == this.sphereDetail) {
            return;
        }
        float f2 = 720.0f / (float)n;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = cosLUT[(int)((float)n2 * f2) % 720];
            fArray2[n2] = sinLUT[(int)((float)n2 * f2) % 720];
            ++n2;
        }
        n2 = n * (n - 1) + 2;
        int n3 = 0;
        this.sphereX = new float[n2];
        this.sphereY = new float[n2];
        this.sphereZ = new float[n2];
        float f3 = f = 360.0f / (float)n;
        int n4 = 1;
        while (n4 < n) {
            float f4 = sinLUT[(int)f3 % 720];
            float f5 = -cosLUT[(int)f3 % 720];
            int n5 = 0;
            while (n5 < n) {
                this.sphereX[n3] = fArray[n5] * f4;
                this.sphereY[n3] = f5;
                this.sphereZ[n3++] = fArray2[n5] * f4;
                ++n5;
            }
            f3 += f;
            ++n4;
        }
        this.sphereDetail = n;
    }

    public void sphere(float f) {
        int n;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (this.sphereDetail == 0) {
            this.sphereDetail(30);
        }
        this.pushMatrix();
        if (f2 != 0.0f && f3 != 0.0f && f4 != 0.0f) {
            this.translate(f2, f3, f4);
        }
        this.scale(f);
        if (this.triangle != null) {
            this.triangle.setCulling(true);
        }
        this.beginShape(65);
        int n2 = 0;
        while (n2 < this.sphereDetail) {
            this.normal(0.0f, -1.0f, 0.0f);
            this.vertex(0.0f, -1.0f, 0.0f);
            this.normal(this.sphereX[n2], this.sphereY[n2], this.sphereZ[n2]);
            this.vertex(this.sphereX[n2], this.sphereY[n2], this.sphereZ[n2]);
            ++n2;
        }
        this.vertex(0.0f, -1.0f, 0.0f);
        this.normal(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.vertex(this.sphereX[0], this.sphereY[0], this.sphereZ[0]);
        this.endShape();
        n2 = 0;
        int n3 = 2;
        while (n3 < this.sphereDetail) {
            int n4;
            int n5 = n4 = n2;
            n = n2 += this.sphereDetail;
            this.beginShape(65);
            int n6 = 0;
            while (n6 < this.sphereDetail) {
                this.normal(this.sphereX[n5], this.sphereY[n5], this.sphereZ[n5]);
                this.vertex(this.sphereX[n5], this.sphereY[n5], this.sphereZ[n5++]);
                this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
                this.vertex(this.sphereX[n], this.sphereY[n], this.sphereZ[n++]);
                ++n6;
            }
            n5 = n4;
            n = n2;
            this.normal(this.sphereX[n5], this.sphereY[n5], this.sphereZ[n5]);
            this.vertex(this.sphereX[n5], this.sphereY[n5], this.sphereZ[n5]);
            this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.vertex(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.endShape();
            ++n3;
        }
        this.beginShape(65);
        n3 = 0;
        while (n3 < this.sphereDetail) {
            n = n2 + n3;
            this.normal(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.vertex(this.sphereX[n], this.sphereY[n], this.sphereZ[n]);
            this.normal(0.0f, 1.0f, 0.0f);
            this.vertex(0.0f, 1.0f, 0.0f);
            ++n3;
        }
        this.normal(this.sphereX[n2], this.sphereY[n2], this.sphereZ[n2]);
        this.vertex(this.sphereX[n2], this.sphereY[n2], this.sphereZ[n2]);
        this.normal(0.0f, 1.0f, 0.0f);
        this.vertex(0.0f, 1.0f, 0.0f);
        this.endShape();
        this.popMatrix();
        if (this.triangle != null) {
            this.triangle.setCulling(false);
        }
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(float f, float f2, float f3) {
        this.forwardTransform.translate(f, f2, f3);
        this.reverseTransform.invTranslate(f, f2, f3);
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotateX(float f) {
        this.forwardTransform.rotateX(f);
        this.reverseTransform.invRotateX(f);
    }

    public void rotateY(float f) {
        this.forwardTransform.rotateY(f);
        this.reverseTransform.invRotateY(f);
    }

    public void rotateZ(float f) {
        this.forwardTransform.rotateZ(f);
        this.reverseTransform.invRotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.forwardTransform.rotate(f, f2, f3, f4);
        this.reverseTransform.invRotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.scale(f, f, f);
    }

    public void scale(float f, float f2) {
        this.scale(f, f2, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.forwardTransform.scale(f, f2, f3);
        this.reverseTransform.invScale(f, f2, f3);
    }

    public void pushMatrix() {
        if (!this.modelview.push()) {
            throw new RuntimeException("Too many calls to pushMatrix()");
        }
        this.modelviewInv.push();
    }

    public void popMatrix() {
        if (!this.modelview.pop()) {
            throw new RuntimeException("Too many calls to popMatrix() (and not enough to pushMatrix)");
        }
        this.modelviewInv.pop();
    }

    public void resetMatrix() {
        this.forwardTransform.reset();
        this.reverseTransform.reset();
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        throw new RuntimeException("Use applyMatrix() with a 4x4 matrix when using OPENGL or P3D");
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.forwardTransform.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.reverseTransform.invApply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public void loadMatrix() {
        this.m00 = this.modelview.m00;
        this.m01 = this.modelview.m01;
        this.m02 = this.modelview.m02;
        this.m03 = this.modelview.m03;
        this.m10 = this.modelview.m10;
        this.m11 = this.modelview.m11;
        this.m12 = this.modelview.m12;
        this.m13 = this.modelview.m13;
        this.m20 = this.modelview.m20;
        this.m21 = this.modelview.m21;
        this.m22 = this.modelview.m22;
        this.m23 = this.modelview.m23;
        this.m30 = this.modelview.m30;
        this.m31 = this.modelview.m31;
        this.m32 = this.modelview.m32;
        this.m33 = this.modelview.m33;
    }

    public void printMatrix() {
        this.modelview.print();
    }

    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
        this.forwardTransform = this.cameraInv;
        this.reverseTransform = this.camera;
    }

    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
        this.manipulatingCamera = false;
    }

    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = PGraphics3D.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        if (f13 != 0.0f) {
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f12 - f16 * f11;
        float f18 = -f14 * f12 + f16 * f10;
        float f19 = f14 * f11 - f15 * f10;
        f14 = f11 * f19 - f12 * f18;
        f15 = -f10 * f19 + f12 * f17;
        f16 = f10 * f18 - f11 * f17;
        f13 = PGraphics3D.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (f13 != 0.0f) {
            f17 /= f13;
            f18 /= f13;
            f19 /= f13;
        }
        if ((f13 = PGraphics3D.sqrt(f14 * f14 + f15 * f15 + f16 * f16)) != 0.0f) {
            f14 /= f13;
            f15 /= f13;
            f16 /= f13;
        }
        this.camera.set(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.camera.translate(-f, -f2, -f3);
        this.cameraInv.reset();
        this.cameraInv.invApply(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        this.cameraInv.invTranslate(-f, -f2, -f3);
        this.modelview.set(this.camera);
        this.modelviewInv.set(this.cameraInv);
    }

    public void printCamera() {
        this.camera.print();
    }

    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, -10.0f, 10.0f);
    }

    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 2.0f / (f2 - f);
        float f8 = 2.0f / (f4 - f3);
        float f9 = -2.0f / (f6 - f5);
        float f10 = -(f2 + f) / (f2 - f);
        float f11 = -(f4 + f3) / (f4 - f3);
        float f12 = -(f6 + f5) / (f6 - f5);
        this.projection.set(f7, 0.0f, 0.0f, f10, 0.0f, f8, 0.0f, f11, 0.0f, 0.0f, f9, f12, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    public void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * this.tan(f / 2.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.projection.set(2.0f * f5 / (f2 - f), 0.0f, (f2 + f) / (f2 - f), 0.0f, 0.0f, 2.0f * f5 / (f4 - f3), (f4 + f3) / (f4 - f3), 0.0f, 0.0f, 0.0f, -(f6 + f5) / (f6 - f5), -(2.0f * f6 * f5) / (f6 - f5), 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public void printProjection() {
        this.projection.print();
    }

    public float screenX(float f, float f2) {
        return this.screenX(f, f2, 0.0f);
    }

    public float screenY(float f, float f2) {
        return this.screenY(f, f2, 0.0f);
    }

    public float screenX(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m00 * f4 + this.projection.m01 * f5 + this.projection.m02 * f6 + this.projection.m03 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.width * (1.0f + f8) / 2.0f;
    }

    public float screenY(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m10 * f4 + this.projection.m11 * f5 + this.projection.m12 * f6 + this.projection.m13 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (float)this.height * (1.0f + f8) / 2.0f;
    }

    public float screenZ(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.projection.m20 * f4 + this.projection.m21 * f5 + this.projection.m22 * f6 + this.projection.m23 * f7;
        float f9 = this.projection.m30 * f4 + this.projection.m31 * f5 + this.projection.m32 * f6 + this.projection.m33 * f7;
        if (f9 != 0.0f) {
            f8 /= f9;
        }
        return (f8 + 1.0f) / 2.0f;
    }

    public float modelX(float f, float f2, float f3) {
        float f4 = this.cameraInv.m00 * f + this.cameraInv.m01 * f2 + this.cameraInv.m02 * f3 + this.cameraInv.m03;
        float f5 = this.cameraInv.m10 * f + this.cameraInv.m11 * f2 + this.cameraInv.m12 * f3 + this.cameraInv.m13;
        float f6 = this.cameraInv.m20 * f + this.cameraInv.m21 * f2 + this.cameraInv.m22 * f3 + this.cameraInv.m23;
        float f7 = this.cameraInv.m30 * f + this.cameraInv.m31 * f2 + this.cameraInv.m32 * f3 + this.cameraInv.m33;
        float f8 = this.modelview.m00 * f4 + this.modelview.m01 * f5 + this.modelview.m02 * f6 + this.modelview.m03 * f7;
        float f9 = this.modelview.m30 * f4 + this.modelview.m31 * f5 + this.modelview.m32 * f6 + this.modelview.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelY(float f, float f2, float f3) {
        float f4 = this.cameraInv.m00 * f + this.cameraInv.m01 * f2 + this.cameraInv.m02 * f3 + this.cameraInv.m03;
        float f5 = this.cameraInv.m10 * f + this.cameraInv.m11 * f2 + this.cameraInv.m12 * f3 + this.cameraInv.m13;
        float f6 = this.cameraInv.m20 * f + this.cameraInv.m21 * f2 + this.cameraInv.m22 * f3 + this.cameraInv.m23;
        float f7 = this.cameraInv.m30 * f + this.cameraInv.m31 * f2 + this.cameraInv.m32 * f3 + this.cameraInv.m33;
        float f8 = this.modelview.m10 * f4 + this.modelview.m11 * f5 + this.modelview.m12 * f6 + this.modelview.m13 * f7;
        float f9 = this.modelview.m30 * f4 + this.modelview.m31 * f5 + this.modelview.m32 * f6 + this.modelview.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public float modelZ(float f, float f2, float f3) {
        float f4 = this.cameraInv.m00 * f + this.cameraInv.m01 * f2 + this.cameraInv.m02 * f3 + this.cameraInv.m03;
        float f5 = this.cameraInv.m10 * f + this.cameraInv.m11 * f2 + this.cameraInv.m12 * f3 + this.cameraInv.m13;
        float f6 = this.cameraInv.m20 * f + this.cameraInv.m21 * f2 + this.cameraInv.m22 * f3 + this.cameraInv.m23;
        float f7 = this.cameraInv.m30 * f + this.cameraInv.m31 * f2 + this.cameraInv.m32 * f3 + this.cameraInv.m33;
        float f8 = this.modelview.m20 * f4 + this.modelview.m21 * f5 + this.modelview.m22 * f6 + this.modelview.m23 * f7;
        float f9 = this.modelview.m30 * f4 + this.modelview.m31 * f5 + this.modelview.m32 * f6 + this.modelview.m33 * f7;
        return f9 != 0.0f ? f8 / f9 : f8;
    }

    public void strokeJoin(int n) {
        String string = "strokeJoin() not available with P3D";
        throw new RuntimeException(string);
    }

    public void strokeCap(int n) {
        String string = "strokeCap() not available with P3D";
        throw new RuntimeException(string);
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.ambientFromCalc();
    }

    public void ambient(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.ambient((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.ambientFromCalc();
        }
    }

    public void ambient(float f) {
        this.colorCalc(f);
        this.ambientFromCalc();
    }

    public void ambient(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.ambientFromCalc();
    }

    protected void ambientFromCalc() {
        this.ambientR = this.calcR;
        this.ambientG = this.calcG;
        this.ambientB = this.calcB;
    }

    public void specular(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.specular((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.specularFromCalc();
        }
    }

    public void specular(float f) {
        this.colorCalc(f);
        this.specularFromCalc();
    }

    public void specular(float f, float f2) {
        this.colorCalc(f, f2);
        this.specularFromCalc();
    }

    public void specular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.specularFromCalc();
    }

    public void specular(float f, float f2, float f3, float f4) {
        this.colorCalc(f, f2, f3, f4);
        this.specularFromCalc();
    }

    protected void specularFromCalc() {
        this.specularR = this.calcR;
        this.specularG = this.calcG;
        this.specularB = this.calcB;
        this.specularA = this.calcA;
    }

    public void shininess(float f) {
        this.shininess = f;
    }

    public void emissive(int n) {
        if ((n & 0xFF000000) == 0 && (float)n <= this.colorModeX) {
            this.emissive((float)n);
        } else {
            this.colorCalcARGB(n, this.colorModeA);
            this.emissiveFromCalc();
        }
    }

    public void emissive(float f) {
        this.colorCalc(f);
        this.emissiveFromCalc();
    }

    public void emissive(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.emissiveFromCalc();
    }

    protected void emissiveFromCalc() {
        this.emissiveR = this.calcR;
        this.emissiveG = this.calcG;
        this.emissiveB = this.calcB;
    }

    public void lights() {
        int n = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = n;
        this.lightingDependsOnVertexPosition = false;
    }

    public void ambientLight(float f, float f2, float f3) {
        this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 0;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightPosition(this.lightCount, f4, f5, f6);
        ++this.lightCount;
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 1;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightDirection(this.lightCount, f4, f5, f6);
        ++this.lightCount;
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 2;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, f4, f5, f6);
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[this.lightCount][0] = this.calcR;
        this.lightDiffuse[this.lightCount][1] = this.calcG;
        this.lightDiffuse[this.lightCount][2] = this.calcB;
        this.lightType[this.lightCount] = 3;
        this.lightFalloffConstant[this.lightCount] = this.currentLightFalloffConstant;
        this.lightFalloffLinear[this.lightCount] = this.currentLightFalloffLinear;
        this.lightFalloffQuadratic[this.lightCount] = this.currentLightFalloffQuadratic;
        this.lightSpecular[this.lightCount][0] = this.currentLightSpecular[0];
        this.lightSpecular[this.lightCount][1] = this.currentLightSpecular[1];
        this.lightSpecular[this.lightCount][2] = this.currentLightSpecular[2];
        this.lightPosition(this.lightCount, f4, f5, f6);
        this.lightDirection(this.lightCount, f7, f8, f9);
        this.lightSpotAngle[this.lightCount] = f10;
        this.lightSpotAngleCos[this.lightCount] = this.max(0.0f, this.cos(f10));
        this.lightSpotConcentration[this.lightCount] = f11;
        ++this.lightCount;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightFalloff(float f, float f2, float f3) {
        this.currentLightFalloffConstant = f;
        this.currentLightFalloffLinear = f2;
        this.currentLightFalloffQuadratic = f3;
        this.lightingDependsOnVertexPosition = true;
    }

    public void lightSpecular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
        this.lightingDependsOnVertexPosition = true;
    }

    protected void lightPosition(int n, float f, float f2, float f3) {
        this.lightPosition[n][0] = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        this.lightPosition[n][1] = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        this.lightPosition[n][2] = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
    }

    protected void lightDirection(int n, float f, float f2, float f3) {
        this.lightNormal[n][0] = this.modelviewInv.m00 * f + this.modelviewInv.m10 * f2 + this.modelviewInv.m20 * f3 + this.modelviewInv.m30;
        this.lightNormal[n][1] = this.modelviewInv.m01 * f + this.modelviewInv.m11 * f2 + this.modelviewInv.m21 * f3 + this.modelviewInv.m31;
        this.lightNormal[n][2] = this.modelviewInv.m02 * f + this.modelviewInv.m12 * f2 + this.modelviewInv.m22 * f3 + this.modelviewInv.m32;
        float f4 = this.mag(this.lightNormal[n]);
        if (f4 == 0.0f || f4 == 1.0f) {
            return;
        }
        float[] fArray = this.lightNormal[n];
        fArray[0] = fArray[0] / f4;
        float[] fArray2 = this.lightNormal[n];
        fArray2[1] = fArray2[1] / f4;
        float[] fArray3 = this.lightNormal[n];
        fArray3[2] = fArray3[2] / f4;
    }

    public void background(PImage pImage) {
        super.background(pImage);
        int n = 0;
        while (n < this.pixelCount) {
            this.zbuffer[n] = Float.MAX_VALUE;
            ++n;
        }
    }

    protected void clear() {
        int n = 0;
        while (n < this.pixelCount) {
            this.pixels[n] = this.backgroundColor;
            this.zbuffer[n] = Float.MAX_VALUE;
            ++n;
        }
    }

    public void smooth() {
        String string = "smooth() not available with P3D";
        throw new RuntimeException(string);
    }

    public void noSmooth() {
        String string = "noSmooth() not available with P3D";
        throw new RuntimeException(string);
    }

    private final float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private final float mag(float[] fArray) {
        return (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
    }

    private final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    private final float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    private final float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    private final float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    private final float cos(float f) {
        return (float)Math.cos(f);
    }

    private final float tan(float f) {
        return (float)Math.tan(f);
    }

    private final float dot(float f, float f2, float f3, float f4, float f5, float f6) {
        return f * f4 + f2 * f5 + f3 * f6;
    }

    private final /* synthetic */ void this() {
        this.tempLightingContribution = new float[9];
        this.worldNormal = new float[4];
        this.dv1 = new float[3];
        this.dv2 = new float[3];
        this.norm = new float[3];
        this.vertex_order = new int[512];
        this.pathOffset = new int[64];
        this.pathLength = new int[64];
        this.lines = new int[512][5];
        this.triangles = new int[256][5];
        this.triangleColors = new float[256][3][8];
        this.textures = new PImage[3];
    }

    public PGraphics3D(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
        this.this();
        this.forwardTransform = this.modelview;
        this.reverseTransform = this.modelviewInv;
    }
}

