/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.ControlP5;
import controlP5.Textfield;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import traer.animation.Smoother3D;
import traer.physics.Particle;
import traer.physics.ParticleSystem;
import traer.physics.Spring;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Affect_Browser
extends PApplet {
    ParticleSystem physics;
    Smoother3D centroid;
    ControlP5 controlP5;
    int ReloadInterval;
    float WorldRestlength;
    float WorldStrength;
    float WorldDamping;
    int WorldSpacer;
    float CloudRestlength;
    float CloudStrength;
    float CloudDamping;
    int CloudSpacer;
    float DotRestlength;
    float DotStrength;
    float DotDamping;
    float DotDampingMultiplier;
    int DotSpacer;
    float InitalDistanceToEdge;
    float DistanceToEdge;
    final float DefaultNodeSize = 40.0f;
    final float NodeSizeMultiplier = 60.0f;
    float North;
    float South;
    PFont font;
    Source[] SourceFiles;
    int SourceFilesConnected;
    int FileLinesConnected;
    Spring[] CloudConnectors;
    Spring[] Similarities;
    int[] MatchStrength;
    String[] MatchedWords;
    String MatchedFocus;
    String[] LoadedTextDocuments;
    Time myTimer;
    boolean ShouldWeLoad;
    boolean firstRun;
    boolean okToMakeSpring;
    P5Properties props;
    boolean IntervalReload;
    boolean DebugMode;
    PImage a;
    PImage christian;
    PImage theText;
    ImageButtons help;
    Textfield url;
    boolean Catchurl;
    Bang LoadFile;
    boolean CatchLoadFile;
    Bang AggregateURLS;
    boolean CatchAggregateURLS;
    Bang LoadUrlFile;
    boolean CatchLoadUrlFile;
    Bang LoadExample;
    boolean CatchLoadExample;
    Bang LinksButton;
    boolean CatchLinksButton;
    Bang ClearButton;
    boolean CatchClearButton;
    Bang ExportButton;
    boolean CatchExportButton;
    boolean loading;
    int IntroCounter;
    int mytint;
    boolean FilechooserIsOpen;
    boolean launchUrlChooserIsOpen;
    boolean ButtonVisible;
    boolean URLVisible;

    public void setup() {
        this.size(this.screen.width, this.screen.height);
        this.background(255);
        if (!this.online) {
            this.frame.setTitle("Affect Browser - Christian Nold - 2006");
        }
        this.colorMode(1, 255.0f);
        this.hint(2);
        this.strokeJoin(2);
        this.font = this.loadFont("DIN-Medium-48.vlw");
        this.SetupInterface();
        this.physics = new ParticleSystem(0.0f, 0.25f);
        this.centroid = new Smoother3D(0.8f);
        this.initialize();
        this.SourceFiles = new Source[0];
        this.Similarities = new Spring[0];
        this.CloudConnectors = new Spring[0];
        this.SourceFilesConnected = 0;
        this.FileLinesConnected = 0;
        this.MatchStrength = new int[0];
        this.MatchedWords = new String[0];
        this.LoadedTextDocuments = new String[0];
    }

    public void draw() {
        if (this.firstRun) {
            this.Intro();
        } else {
            this.normal();
        }
    }

    public void normal() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.SourceFiles.length) {
            if (this.SourceFiles[n2].Loaded) {
                ++n;
            }
            ++n2;
        }
        if (n == this.SourceFiles.length) {
            try {
                this.physics.tick(1.0f);
                this.updateCentroid();
                this.centroid.tick();
            }
            catch (NullPointerException nullPointerException) {
                Affect_Browser.println((String)(" physics.tick" + nullPointerException));
            }
        }
        this.background(255);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.scale(this.centroid.z());
        this.translate(-this.centroid.x(), -this.centroid.y());
        this.drawNetwork();
        this.popMatrix();
        this.UpdateInterface();
        this.endRecord();
    }

    public void drawNetwork() {
        this.noFill();
        this.ConnectMatchedWords();
        this.noStroke();
        int n = 0;
        while (n < this.SourceFiles.length) {
            this.SourceFiles[n].Update();
            ++n;
        }
    }

    public void ConnectClouds() {
        this.strokeWeight(2.0f);
        this.stroke(0);
        int n = 0;
        while (n < this.CloudConnectors.length) {
            Spring spring = this.CloudConnectors[n];
            Particle particle = spring.getOneEnd();
            Particle particle2 = spring.getTheOtherEnd();
            this.line(particle.position().x(), particle.position().y(), particle2.position().x(), particle2.position().y());
            ++n;
        }
    }

    public void test() {
        this.fill(100);
        int n = 0;
        while (n < this.physics.numberOfParticles()) {
            Particle particle = this.physics.getParticle(n);
            this.ellipse(particle.position().x(), particle.position().y(), 20.0f, 20.0f);
            ++n;
        }
    }

    public void ConnectMatchedWords() {
        this.stroke(220);
        int n = 0;
        while (n < this.Similarities.length) {
            Spring spring = this.Similarities[n];
            float f = (float)this.MatchStrength[n] / 1.5f;
            if (f < 1.0f) {
                f = 1.0f;
            }
            this.strokeWeight(f);
            Particle particle = spring.getOneEnd();
            Particle particle2 = spring.getTheOtherEnd();
            float f2 = particle.position().x() + 100.0f;
            float f3 = particle.position().y() - 100.0f;
            float f4 = particle2.position().x() - 100.0f;
            float f5 = particle2.position().y() + 100.0f;
            this.bezier(particle.position().x(), particle.position().y(), f2, f3, f4, f5, particle2.position().x(), particle2.position().y());
            this.strokeWeight(1.0f);
            ++n;
        }
    }

    public void updateCentroid() {
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < this.physics.numberOfParticles()) {
            Particle particle = this.physics.getParticle(n);
            f = Affect_Browser.max((float)f, (float)particle.position().x());
            f2 = Affect_Browser.min((float)f2, (float)particle.position().x());
            f3 = Affect_Browser.min((float)f3, (float)particle.position().y());
            f4 = Affect_Browser.max((float)f4, (float)particle.position().y());
            ++n;
        }
        float f5 = f4 - f3;
        float f6 = f - f2;
        if (f5 > f6) {
            this.centroid.setTarget(f2 + 0.5f * (f6 + this.North), f3 + 0.5f * (f5 - this.South), (float)this.height / (f5 + this.DistanceToEdge));
        } else {
            this.centroid.setTarget(f2 + 0.5f * (f6 + this.North), f3 + 0.5f * (f5 - this.South), (float)this.width / (f6 + this.DistanceToEdge));
        }
    }

    public void initialize() {
        this.physics.clear();
        this.physics.makeParticle();
        this.centroid.setValue(0.0f, 0.0f, 1.0f);
    }

    public void reset() {
        this.physics.clear();
        this.IntervalReload = false;
        this.SourceFiles = new Source[0];
        this.Similarities = new Spring[0];
        this.CloudConnectors = new Spring[0];
        this.MatchStrength = new int[0];
        this.MatchedWords = new String[0];
        this.LoadedTextDocuments = new String[0];
        this.SourceFilesConnected = 0;
        this.FileLinesConnected = 0;
        this.physics.makeParticle();
        this.centroid.setValue(0.0f, 0.0f, 1.0f);
    }

    public void increaseSource() {
        this.SourceFiles = (Source[])Affect_Browser.append((Object)this.SourceFiles, (Object)new Source());
        Affect_Browser.println((String)("There are " + this.SourceFiles.length + " Source Objects"));
    }

    public void printIt() {
        Affect_Browser.println((String)" ");
        Affect_Browser.println((String)"DEBUGGING");
        Affect_Browser.println((String)("Interval Mode: " + this.IntervalReload));
        Affect_Browser.println((String)("Uptime since reset: " + this.myTimer.millis()));
        Affect_Browser.println((String)("There are " + this.SourceFiles.length + " Texts loaded"));
        Affect_Browser.println((String)("Physics says there are " + this.physics.numberOfParticles() + " particles"));
        int n = 0;
        while (n < this.SourceFiles.length) {
            Affect_Browser.println((String)("Text " + this.SourceFiles[n].word));
            int n2 = 0;
            while (n2 < this.SourceFiles[n].Cloudnum) {
                Affect_Browser.println((String)("Cloud " + this.SourceFiles[n].Cloud[n2].word + " has " + this.SourceFiles[n].Cloud[n2].DotNum + " Dots"));
                Affect_Browser.println((String)("Cloud " + this.SourceFiles[n].Cloud[n2].WordArray.length));
                ++n2;
            }
            ++n;
        }
        Affect_Browser.println((String)("There are CloudConnectors:  " + this.CloudConnectors.length));
        Affect_Browser.println((String)("Number of Matched Words:  " + this.Similarities.length));
        Affect_Browser.println((String)("Matchstrength is this long: " + this.MatchStrength.length));
        Affect_Browser.println((String)"Documents Loaded:");
        n = 0;
        while (n < this.LoadedTextDocuments.length) {
            Affect_Browser.println((String)this.LoadedTextDocuments[n]);
            ++n;
        }
    }

    public void addSpacersToNode(Particle particle, Particle particle2, int n) {
        int n2 = 0;
        while (n2 < this.physics.numberOfParticles()) {
            Particle particle3 = this.physics.getParticle(n2);
            if (particle != particle3 && particle != particle2) {
                this.physics.makeAttraction(particle, particle3, (float)(-n), 20.0f);
            }
            ++n2;
        }
    }

    public void makeEdgeBetween(Particle particle, Particle particle2, float f, float f2, float f3) {
        this.physics.makeSpring(particle, particle2, f, f2, f3);
    }

    public void ClverConnect() {
        Affect_Browser.println((String)("FileConnected" + this.FileLinesConnected));
        Affect_Browser.println((String)("SourceFiles" + this.SourceFiles.length));
        this.Similarities = new Spring[0];
        this.MatchStrength = new int[0];
        this.MatchedWords = new String[0];
        if (this.SourceFiles.length - this.FileLinesConnected > 0) {
            this.MatchedFocus = this.SourceFiles[this.FileLinesConnected].word;
            int n = 0;
            while (n < this.SourceFiles[this.FileLinesConnected].Cloudnum) {
                int n2 = 0;
                while (n2 < this.SourceFiles[this.FileLinesConnected].Cloud[n].DotNum) {
                    String string = this.SourceFiles[this.FileLinesConnected].Cloud[n].Dot[n2].word;
                    Particle particle = this.SourceFiles[this.FileLinesConnected].Cloud[n].Dot[n2].particle;
                    int n3 = 0;
                    while (n3 < this.SourceFiles.length) {
                        if (n3 != this.FileLinesConnected) {
                            int n4 = 0;
                            while (n4 < this.SourceFiles[n3].Cloudnum) {
                                int n5 = 0;
                                while (n5 < this.SourceFiles[n3].Cloud[n4].DotNum) {
                                    String string2 = this.SourceFiles[n3].Cloud[n4].Dot[n5].word;
                                    if (string.equals(string2)) {
                                        Particle particle2 = this.SourceFiles[n3].Cloud[n4].Dot[n5].particle;
                                        int n6 = this.SourceFiles[this.FileLinesConnected].Cloud[n].Dot[n2].frequency + this.SourceFiles[n3].Cloud[n4].Dot[n5].frequency;
                                        this.physics.makeSpring(particle, particle2, 0.0f, 0.0f, 0.0f);
                                        int n7 = this.physics.numberOfSprings();
                                        Spring spring = this.physics.getSpring(n7 - 1);
                                        this.Similarities = (Spring[])Affect_Browser.append((Object)this.Similarities, (Object)spring);
                                        this.MatchStrength = Affect_Browser.append((int[])this.MatchStrength, (int)(n6 / 2));
                                        if (!this.find(string, this.MatchedWords)) {
                                            this.MatchedWords = Affect_Browser.append((String[])this.MatchedWords, (String)string);
                                        }
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            ++this.FileLinesConnected;
        } else {
            this.FileLinesConnected = 0;
        }
    }

    public boolean find(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void ConsensusWords() {
        Affect_Browser.println((String)("FileConnected" + this.FileLinesConnected));
        Affect_Browser.println((String)("SourceFiles" + this.SourceFiles.length));
        this.Similarities = new Spring[0];
        this.MatchStrength = new int[0];
        this.MatchedWords = new String[0];
        if (this.SourceFiles.length > 0 && this.FileLinesConnected < this.SourceFiles.length) {
            this.MatchedFocus = this.SourceFiles[this.FileLinesConnected].word;
            int n = 0;
            while (n < this.SourceFiles.length) {
                int n2 = 0;
                while (n2 < this.SourceFiles[n].Cloudnum) {
                    if (this.SourceFiles[n].Cloud[n2].mode.equals("match")) {
                        int n3 = 0;
                        while (n3 < this.SourceFiles[n].Cloud[n2].DotNum) {
                            String string = this.SourceFiles[n].Cloud[n2].Dot[n3].word;
                            Particle particle = this.SourceFiles[n].Cloud[n2].Dot[n3].particle;
                            int n4 = 0;
                            while (n4 < this.SourceFiles.length) {
                                if (n4 != this.FileLinesConnected) {
                                    int n5 = 0;
                                    while (n5 < this.SourceFiles[n4].Cloudnum) {
                                        int n6 = 0;
                                        while (n6 < this.SourceFiles[n4].Cloud[n5].DotNum) {
                                            String string2 = this.SourceFiles[n4].Cloud[n5].Dot[n6].word;
                                            if (string.equals(string2)) {
                                                Spring spring;
                                                Particle particle2 = this.SourceFiles[n4].Cloud[n5].Dot[n6].particle;
                                                int n7 = this.SourceFiles[this.FileLinesConnected].Cloud[n2].Dot[n3].frequency + this.SourceFiles[n4].Cloud[n5].Dot[n6].frequency;
                                                if (this.Similarities.length == 0) {
                                                    this.okToMakeSpring = true;
                                                }
                                                int n8 = 0;
                                                while (n8 < this.Similarities.length) {
                                                    spring = this.Similarities[n8];
                                                    Particle particle3 = spring.getOneEnd();
                                                    Particle particle4 = spring.getTheOtherEnd();
                                                    this.okToMakeSpring = particle != particle3 && particle != particle4 || particle2 != particle3 || particle2 != particle4;
                                                    ++n8;
                                                }
                                                if (this.okToMakeSpring) {
                                                    this.physics.makeSpring(particle, particle2, 0.0f, 0.0f, 0.0f);
                                                    n8 = this.physics.numberOfSprings();
                                                    spring = this.physics.getSpring(n8 - 1);
                                                    this.Similarities = (Spring[])Affect_Browser.append((Object)this.Similarities, (Object)spring);
                                                    this.MatchStrength = Affect_Browser.append((int[])this.MatchStrength, (int)(n7 / 2));
                                                    if (!this.find(string, this.MatchedWords)) {
                                                        this.MatchedWords = Affect_Browser.append((String[])this.MatchedWords, (String)string);
                                                    }
                                                    this.okToMakeSpring = false;
                                                }
                                            }
                                            ++n6;
                                        }
                                        ++n5;
                                    }
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                ++this.FileLinesConnected;
                ++n;
            }
        }
    }

    public void SetupInterface() {
        this.smooth();
        this.frameRate(24.0f);
        this.strokeWeight(2.0f);
        this.ellipseMode(3);
        this.controlP5 = new ControlP5((PApplet)this);
        this.controlP5.hide();
        this.url = this.controlP5.addTextfield("url", 20.0f, (float)(this.height - 360), 170, 20);
        this.url.setLabel("Enter a URL ( www... )");
        this.LoadFile = this.controlP5.addBang("LoadFile", 20.0f, (float)(this.height - 320), 20, 15);
        this.LoadFile.setLabel("Import single txt");
        this.LoadUrlFile = this.controlP5.addBang("LoadUrlFile", 20.0f, (float)(this.height - 280), 20, 15);
        this.LoadUrlFile.setLabel("Import Url list");
        this.AggregateURLS = this.controlP5.addBang("AggregateURLS", 20.0f, (float)(this.height - 240), 20, 15);
        this.AggregateURLS.setLabel("Aggregate Url list");
        this.LoadExample = this.controlP5.addBang("LoadExample", 20.0f, (float)(this.height - 200), 20, 15);
        this.LoadExample.setLabel("Load example");
        this.LinksButton = this.controlP5.addBang("LinksButton", 20.0f, (float)(this.height - 160), 20, 15);
        this.LinksButton.setLabel("Find matched words between texts");
        this.ClearButton = this.controlP5.addBang("ClearButton", 20.0f, (float)(this.height - 120), 20, 15);
        this.ClearButton.setLabel("Clear and reset");
        this.ExportButton = this.controlP5.addBang("ExportButton", 20.0f, (float)(this.height - 80), 20, 15);
        this.ExportButton.setLabel("Export PDF");
        this.controlP5.setColorBackground(this.color(255));
        this.controlP5.setColorForeground(this.color(71, 70, 108));
        this.controlP5.setColorValue(this.color(130));
        this.controlP5.setColorLabel(this.color(0, 0, 0));
        this.controlP5.setColorActive(this.color(255, 100, 60));
        this.a = this.loadImage("affect.png");
        this.christian = this.loadImage("christian.png");
        this.theText = this.loadImage("text.png");
        int n = 15;
        int n2 = 290;
        int n3 = 100;
        int n4 = 20;
        this.help = new ImageButtons(15, 15, n3, n4, this.a, this.a, this.a);
    }

    public void url(String string) {
        if (this.Catchurl) {
            String string2 = "http://" + string;
            Affect_Browser.println((String)string2);
            this.loading = true;
            this.LoadURL(string2);
        } else {
            this.Catchurl = true;
        }
    }

    public void LoadFile() {
        if (this.CatchLoadFile) {
            if (!this.FilechooserIsOpen) {
                this.launchChooser();
            }
        } else {
            this.CatchLoadFile = true;
        }
    }

    public void LoadUrlFile() {
        if (this.CatchLoadUrlFile) {
            if (!this.launchUrlChooserIsOpen) {
                this.launchUrlChooser();
            }
        } else {
            this.CatchLoadUrlFile = true;
        }
    }

    public void AggregateURLS() {
        if (this.CatchAggregateURLS) {
            if (!this.launchUrlChooserIsOpen) {
                this.AggregateURLSChooser();
            }
        } else {
            this.CatchAggregateURLS = true;
        }
    }

    public void LoadExample() {
        if (this.CatchLoadExample) {
            this.increaseSource();
            this.SourceFiles[this.SourceFiles.length - 1].launchExample("example.txt", "example");
            this.LoadedTextDocuments = Affect_Browser.append((String[])this.LoadedTextDocuments, (String)"example");
        } else {
            this.CatchLoadExample = true;
        }
    }

    public void LinksButton() {
        if (this.CatchLinksButton) {
            this.ClverConnect();
        } else {
            this.CatchLinksButton = true;
        }
    }

    public void ClearButton() {
        if (this.CatchClearButton) {
            this.reset();
        } else {
            this.CatchClearButton = true;
        }
    }

    public void ExportButton() {
        if (this.CatchExportButton) {
            this.MakePDF();
        } else {
            this.CatchExportButton = true;
        }
    }

    public void MakePDF() {
        String string = "Affect " + Affect_Browser.hour() + '.' + Affect_Browser.minute() + '.' + Affect_Browser.second() + ' ' + Affect_Browser.day() + ':' + Affect_Browser.month() + ':' + Affect_Browser.year() + ".pdf";
        this.beginRecord("processing.pdf.PGraphicsPDF", string);
        Affect_Browser.println((String)("PDF created: " + string));
    }

    public void IntervalTimeCheck() {
        int n = this.myTimer.millis();
        if (n > this.ReloadInterval) {
            this.MakePDF();
            Affect_Browser.println((String)"reloading");
            this.physics.clear();
            this.SourceFiles = new Source[0];
            this.Similarities = new Spring[0];
            this.CloudConnectors = new Spring[0];
            this.MatchStrength = new int[0];
            this.MatchedWords = new String[0];
            this.SourceFilesConnected = 0;
            this.FileLinesConnected = 0;
            this.physics.makeParticle();
            this.centroid.setValue(0.0f, 0.0f, 1.0f);
            String[] stringArray = this.LoadedTextDocuments;
            this.LoadedTextDocuments = new String[0];
            this.LoadUrlList(stringArray);
            this.myTimer.resetTime();
        }
    }

    public void UpdateInterface() {
        if (this.IntervalReload) {
            this.IntervalTimeCheck();
        }
        this.Display();
        this.help.update();
        this.help.display();
        if (this.help.over) {
            this.image(this.theText, 15.0f, 29.0f);
        }
    }

    public void LoadUrlList(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Affect_Browser.println((String)stringArray[n]);
            this.LoadURL(stringArray[n]);
            ++n;
        }
    }

    public void Intro() {
        if (this.mousePressed) {
            this.firstRun = false;
            this.controlP5.show();
        }
        if (this.IntroCounter > 15) {
            this.tint(255, this.mytint);
            this.image(this.a, this.width / 2 - this.a.width / 2, this.height / 2 - this.a.height / 2 - 15);
            this.image(this.christian, this.width / 2 - this.christian.width / 2, this.height / 2 - this.christian.height / 2 + 15);
            ++this.mytint;
            this.noTint();
        }
        ++this.IntroCounter;
        this.delay(15);
        if (this.firstRun && this.IntroCounter == 150) {
            this.background(255);
            this.firstRun = false;
            this.controlP5.show();
        }
    }

    public void LoadURL(String string) {
        String string2 = string;
        String string3 = string;
        URL uRL = null;
        String[] stringArray = new String[]{};
        boolean bl = false;
        try {
            InputStream inputStream;
            uRL = new URL(string3);
            if (uRL != null && (stringArray = Affect_Browser.loadStrings((InputStream)(inputStream = uRL.openStream()))) != null) {
                bl = true;
            }
            if (bl) {
                this.increaseSource();
                this.SourceFiles[this.SourceFiles.length - 1].URLReceive(string2, stringArray);
                this.LoadedTextDocuments = Affect_Browser.append((String[])this.LoadedTextDocuments, (String)string2);
                this.loading = false;
            }
        }
        catch (Exception exception) {
            Affect_Browser.println((String)("URL error" + exception));
            bl = false;
            this.loading = false;
        }
    }

    public void AggregateURLFile(String string, String[] stringArray) {
        String string2 = "";
        String string3 = "";
        URL uRL = null;
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = new String[]{};
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n];
            string3 = stringArray[n];
            try {
                Object object;
                uRL = new URL(string3);
                if (uRL != null && (stringArray2 = Affect_Browser.loadStrings((InputStream)(object = uRL.openStream()))) != null) {
                    bl = true;
                }
                if (bl) {
                    object = Affect_Browser.join((String[])stringArray2, (String)" ");
                    stringArray3 = Affect_Browser.append((String[])stringArray3, (String)object);
                }
            }
            catch (Exception exception) {
                Affect_Browser.println((String)("URL error" + exception));
                bl = false;
                this.loading = false;
            }
            ++n;
        }
        String string4 = Affect_Browser.join((String[])stringArray3, (String)" ");
        stringArray3 = Affect_Browser.split((String)string4);
        this.increaseSource();
        this.SourceFiles[this.SourceFiles.length - 1].URLReceive(string, stringArray3);
        this.LoadedTextDocuments = Affect_Browser.append((String[])this.LoadedTextDocuments, (String)string);
        this.loading = false;
    }

    public void LoadingAnim() {
        this.textFont(this.font, 32.0f);
        this.text("Loading", 100.0f, 100.0f);
    }

    public void Display() {
        int n;
        int n2 = this.LoadedTextDocuments.length;
        if (n2 > 0) {
            this.fill(140);
            this.textFont(this.font, 10.0f);
            this.text(n2 + " Texts Loaded:", 20.0f, 60.0f);
            this.textFont(this.font, 8.0f);
            n = 0;
            while (n < this.LoadedTextDocuments.length) {
                this.text(this.LoadedTextDocuments[n], 20.0f, n * 10 + 80);
                ++n;
            }
        }
        if (this.MatchedWords.length > 0) {
            this.fill(140);
            this.textFont(this.font, 10.0f);
            this.text("Focus on:", this.width - 140, 60.0f);
            this.fill(255.0f, 100.0f, 100.0f);
            this.pushMatrix();
            this.translate(this.width - 140, 80.0f);
            this.rotate(1.5707964f);
            this.text(this.MatchedFocus, 0.0f, 0.0f);
            this.popMatrix();
            this.fill(140);
            this.textFont(this.font, 8.0f);
            n = 0;
            while (n < this.MatchedWords.length) {
                this.text(this.MatchedWords[n], this.width - 120, n * 10 + 80);
                ++n;
            }
        }
    }

    public void LoadingText() {
        this.fill(150);
        this.textFont(this.font, 10.0f);
        this.text(" Loading:", 20.0f, 100.0f);
    }

    public void launchChooser() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        String string = file.getName().toLowerCase();
                        if (string.endsWith(".txt") || string.endsWith(".htm") || string.endsWith(".html")) {
                            String string2 = file.getName();
                            Affect_Browser.this.increaseSource();
                            Affect_Browser.this.SourceFiles[Affect_Browser.this.SourceFiles.length - 1].fielOpen(string2, file);
                            Affect_Browser.this.LoadedTextDocuments = Affect_Browser.append((String[])Affect_Browser.this.LoadedTextDocuments, (String)string2);
                        } else {
                            Affect_Browser.this.FilechooserIsOpen = false;
                        }
                    } else {
                        Affect_Browser.println((String)"Open command cancelled by user.");
                        Affect_Browser.this.FilechooserIsOpen = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void AggregateURLSChooser() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        String string = file.getName().toLowerCase();
                        if (string.endsWith(".txt") || string.endsWith(".htm") || string.endsWith(".html")) {
                            String string2 = file.getName();
                            String[] stringArray = Affect_Browser.loadStrings((File)file);
                            Affect_Browser.this.AggregateURLFile(string2, stringArray);
                        } else {
                            Affect_Browser.this.launchUrlChooserIsOpen = false;
                        }
                    } else {
                        Affect_Browser.println((String)"Open command cancelled by user.");
                        Affect_Browser.this.launchUrlChooserIsOpen = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void launchUrlChooser() {
        SwingUtilities.invokeLater(new Runnable(){

            public final void run() {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        String string = file.getName().toLowerCase();
                        if (string.endsWith(".txt") || string.endsWith(".htm") || string.endsWith(".html")) {
                            String string2 = file.getName();
                            String[] stringArray = Affect_Browser.loadStrings((File)file);
                            Affect_Browser.this.LoadUrlList(stringArray);
                        } else {
                            Affect_Browser.this.launchUrlChooserIsOpen = false;
                        }
                    } else {
                        Affect_Browser.println((String)"Open command cancelled by user.");
                        Affect_Browser.this.launchUrlChooserIsOpen = false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void keyPressed() {
        if (this.key == ';') {
            Affect_Browser.println((String)("Similarities: " + this.Similarities.length));
            Affect_Browser.println((boolean)this.okToMakeSpring);
            return;
        }
        if (this.key == '\u00a7') {
            this.IntervalReload = !this.IntervalReload;
            Affect_Browser.println((String)("IntervalReload: " + this.IntervalReload));
            return;
        }
        if (this.key == '`') {
            this.DebugMode = !this.DebugMode;
            Affect_Browser.println((String)("DebugMode: " + this.DebugMode));
            this.printIt();
            return;
        }
        if (this.key == '.') {
            this.DistanceToEdge -= 30.0f;
            return;
        }
        if (this.key == ',') {
            this.DistanceToEdge += 30.0f;
            return;
        }
        if (this.key == ' ') {
            this.DistanceToEdge = this.InitalDistanceToEdge;
            this.North = 1.0f;
            this.South = 1.0f;
            return;
        }
        if (this.keyCode == 38) {
            this.South += 30.0f;
            return;
        }
        if (this.keyCode == 40) {
            this.South -= 30.0f;
            return;
        }
        if (this.keyCode == 39) {
            this.North += 30.0f;
            return;
        }
        if (this.keyCode == 37) {
            this.North -= 30.0f;
            return;
        }
        if (this.keyCode == 61) {
            this.ConsensusWords();
            return;
        }
    }

    public void handleError(Exception exception, StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < Affect_Browser.min((int)30, (int)stackTraceElementArray.length)) {
            stringBuffer.append(stackTraceElementArray[n]);
            stringBuffer.append('\n');
            ++n;
        }
        n = JOptionPane.showOptionDialog((Component)((Object)this), stringBuffer + "\nContinue?", exception.toString(), 2, 0, null, null, null);
        if (n != 0) {
            System.exit(-1);
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"Affect_Browser"});
    }

    private final /* synthetic */ void this() {
        this.ReloadInterval = 2000000;
        this.WorldRestlength = 0.02f;
        this.WorldStrength = 0.05f;
        this.WorldDamping = 40.0f;
        this.WorldSpacer = 10000;
        this.CloudRestlength = 0.1f;
        this.CloudStrength = 0.05f;
        this.CloudDamping = 40.0f;
        this.CloudSpacer = 1000;
        this.DotRestlength = 0.05f;
        this.DotStrength = 0.05f;
        this.DotDamping = 40.0f;
        this.DotDampingMultiplier = 3;
        this.DotSpacer = 1000;
        this.DistanceToEdge = this.InitalDistanceToEdge = 500.0f;
        this.North = 1.0f;
        this.South = 1.0f;
        this.myTimer = new Time();
        this.ShouldWeLoad = false;
        this.firstRun = true;
        this.okToMakeSpring = false;
        this.IntervalReload = false;
        this.DebugMode = false;
        this.Catchurl = false;
        this.CatchLoadFile = false;
        this.CatchAggregateURLS = false;
        this.CatchLoadUrlFile = false;
        this.CatchLoadExample = false;
        this.CatchLinksButton = false;
        this.CatchClearButton = false;
        this.CatchExportButton = false;
        this.loading = false;
        this.IntroCounter = 0;
        this.mytint = 0;
        this.FilechooserIsOpen = false;
        this.launchUrlChooserIsOpen = false;
        this.ButtonVisible = false;
        this.URLVisible = false;
    }

    public Affect_Browser() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Source {
        String method;
        String url;
        String word;
        int DotSize = 20;
        int FontSize = 10;
        String[] Text;
        String[] CloudTexts;
        String[] temp;
        float Textwidth;
        float AffectPercentage;
        boolean toggle;
        boolean loaded;
        Particle particle;
        boolean Loaded;
        Cloud[] Cloud;
        int Cloudnum;
        float PosX;
        float PosY;

        public void launchExample(String string, String string2) {
            this.Text = Affect_Browser.this.loadStrings(string);
            this.word = string2;
            this.Trigger();
        }

        public void URLReceive(String string, String[] stringArray) {
            this.word = string;
            this.Text = stringArray;
            this.GetTextReady();
            this.MakeClouds();
        }

        public void fielOpen(String string, File file) {
            this.word = string.substring(0, string.length() - 4);
            this.Text = Affect_Browser.loadStrings((File)file);
            this.Trigger();
        }

        public void Trigger() {
            Affect_Browser.this.textFont(Affect_Browser.this.font, 10.0f);
            this.Textwidth = Affect_Browser.this.textWidth(this.word);
            this.Textwidth /= 2.0f;
            this.GetTextReady();
            this.MakeClouds();
            Affect_Browser.this.FilechooserIsOpen = false;
        }

        public void GetTextReady() {
            String string = Affect_Browser.join((String[])this.Text, (String)" ");
            String string2 = string.toLowerCase();
            string2 = this.Regex(string2);
            this.Text = Affect_Browser.split((String)string2);
            if (Affect_Browser.this.DebugMode) {
                Affect_Browser.this.saveStrings("regex" + Affect_Browser.this.SourceFiles.length + ".txt", this.Text);
            }
        }

        public String Regex(String string) {
            String string2 = "<(script|style)[^>]*>(.*?)<\\/(script|style)>";
            Pattern pattern = Pattern.compile(string2, 2);
            Matcher matcher = pattern.matcher(string);
            int n = 0;
            while (matcher.find()) {
                ++n;
            }
            string = matcher.replaceAll(" ");
            String string3 = "<[^>]*>";
            Pattern pattern2 = Pattern.compile(string3);
            Matcher matcher2 = pattern2.matcher(string);
            n = 0;
            while (matcher2.find()) {
                ++n;
            }
            string = matcher2.replaceAll(" ");
            String string4 = "&quot|&amp|&lt|&OElig|&oelig|&Scaron|&scaron|&Yuml|&circ|&tilde|&ensp|&nbsp|&gt|&iexcl|&rdquo|&ldquo|&copy|&rsquo|&pound";
            Pattern pattern3 = Pattern.compile(string4);
            Matcher matcher3 = pattern3.matcher(string);
            n = 0;
            while (matcher3.find()) {
                ++n;
            }
            string = matcher3.replaceAll(" ");
            String string5 = "(&#)\\d*";
            Pattern pattern4 = Pattern.compile(string5);
            Matcher matcher4 = pattern4.matcher(string);
            n = 0;
            while (matcher4.find()) {
                ++n;
            }
            string = matcher4.replaceAll(" ");
            String string6 = "\\d";
            Pattern pattern5 = Pattern.compile(string6);
            Matcher matcher5 = pattern5.matcher(string);
            n = 0;
            while (matcher5.find()) {
                ++n;
            }
            string = matcher5.replaceAll(" ");
            String string7 = "[/?!,@+\\]\\[&*<>/.()\u00e4\u00f4\u201a\u00ac\u2020\u00a9:;\u201c\u201d\"{}\u2018\u00b7\u2019'`~=|-]";
            Pattern pattern6 = Pattern.compile(string7);
            Matcher matcher6 = pattern6.matcher(string);
            n = 0;
            while (matcher6.find()) {
                ++n;
            }
            string = matcher6.replaceAll(" ");
            String string8 = "(\\n{2})\\s*\\n+";
            string = string.replaceAll(string8, "$1");
            return string;
        }

        public void MakeClouds() {
            this.Cloudnum = 3;
            int n = 30;
            this.Cloud = new Cloud[this.Cloudnum];
            this.CloudTexts = new String[this.Cloudnum];
            int n2 = Affect_Browser.this.color(190.0f + Affect_Browser.this.random(n), 0.0f + Affect_Browser.this.random(n), 0.0f + Affect_Browser.this.random(n));
            int n3 = Affect_Browser.this.color(0);
            int n4 = Affect_Browser.this.color(255);
            this.Cloud[0] = new Cloud("positive.txt", "match", n2, n3, n4, this.Text);
            n2 = Affect_Browser.this.color(0.0f + Affect_Browser.this.random(n), 0.0f + Affect_Browser.this.random(n), 190.0f + Affect_Browser.this.random(n));
            n3 = Affect_Browser.this.color(0);
            n4 = Affect_Browser.this.color(255);
            this.Cloud[1] = new Cloud("negative.txt", "match", n2, n3, n4, this.Text);
            n2 = Affect_Browser.this.color(255.0f - Affect_Browser.this.random(n), 215.0f - Affect_Browser.this.random(n), 0.0f + Affect_Browser.this.random(n));
            n3 = Affect_Browser.this.color(0);
            n4 = Affect_Browser.this.color(255);
            this.Cloud[2] = new Cloud("stopwords.txt", "remove", n2, n3, n4, this.Text);
            this.FinishedLoading();
        }

        public void CloudConnect() {
            int n = 0;
            while (n < this.Cloudnum) {
                Particle particle = this.Cloud[n].particle;
                Affect_Browser.this.addSpacersToNode(particle, this.particle, Affect_Browser.this.CloudSpacer);
                Affect_Browser.this.makeEdgeBetween(particle, this.particle, Affect_Browser.this.CloudRestlength, Affect_Browser.this.CloudStrength, Affect_Browser.this.CloudDamping);
                particle.moveTo(this.particle.position().x() + Affect_Browser.this.random(-1.0f, 1.0f), this.particle.position().y() + Affect_Browser.this.random(-1.0f, 1.0f), 0.0f);
                int n2 = Affect_Browser.this.physics.numberOfSprings();
                Spring spring = Affect_Browser.this.physics.getSpring(n2 - 1);
                Affect_Browser.this.CloudConnectors = (Spring[])Affect_Browser.append((Object)Affect_Browser.this.CloudConnectors, (Object)spring);
                ++n;
            }
        }

        public void FinishedLoading() {
            this.CloudConnect();
            this.Loaded = true;
        }

        public void Update() {
            if (this.Loaded) {
                this.TextCirlce();
                this.PosX = this.particle.position().x();
                this.PosY = this.particle.position().y();
                Affect_Browser.this.fill(255);
                Affect_Browser.this.textFont(Affect_Browser.this.font, 10.0f);
                Affect_Browser.this.rect(this.PosX - (float)5, this.PosY - 10.0f, this.Textwidth + 10.0f, 16.0f);
                Affect_Browser.this.fill(0);
                Affect_Browser.this.text(this.word, this.PosX, this.PosY);
                int n = 0;
                while (n < this.Cloudnum) {
                    this.Cloud[n].Update();
                    ++n;
                }
            }
        }

        public void TextCirlce() {
            Affect_Browser.this.strokeWeight(2.0f);
            Affect_Browser.this.stroke(0);
            Affect_Browser.this.noFill();
            Affect_Browser.this.beginShape();
            Affect_Browser.this.curveVertex(this.Cloud[2].PosX, this.Cloud[2].PosY);
            int n = 0;
            while (n < this.Cloudnum) {
                if (this.Cloud[n].DotNum > 0) {
                    Affect_Browser.this.curveVertex(this.Cloud[n].PosX, this.Cloud[n].PosY);
                }
                ++n;
            }
            Affect_Browser.this.curveVertex(this.Cloud[0].PosX, this.Cloud[0].PosY);
            Affect_Browser.this.curveVertex(this.Cloud[1].PosX, this.Cloud[1].PosY);
            Affect_Browser.this.endShape();
            Affect_Browser.this.noStroke();
        }

        Source() {
            this.particle = Affect_Browser.this.physics.makeParticle();
            this.PosX = this.particle.position().x();
            this.PosY = this.particle.position().y();
            Affect_Browser.this.addSpacersToNode(this.particle, Affect_Browser.this.physics.getParticle(0), Affect_Browser.this.WorldSpacer);
            Affect_Browser.this.makeEdgeBetween(this.particle, Affect_Browser.this.physics.getParticle(0), Affect_Browser.this.WorldRestlength, Affect_Browser.this.WorldStrength, Affect_Browser.this.WorldDamping);
            this.particle.moveTo(Affect_Browser.this.physics.getParticle(0).position().x() + Affect_Browser.this.random(-5.0f, 5), Affect_Browser.this.physics.getParticle(0).position().y() + Affect_Browser.this.random(-5.0f, 5), 0.0f);
            this.Text = null;
            this.Loaded = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Time
    implements Cloneable {
        private long t = System.currentTimeMillis();

        public int millis() {
            return (int)(System.currentTimeMillis() - this.t);
        }

        public void resetTime() {
            this.t = System.currentTimeMillis();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Cloud {
        Words Words;
        Word[] WordArray;
        Word thisword;
        String family;
        String word;
        String filename;
        String mode;
        String[] raw;
        int DotNum;
        String[] SourceText;
        String CloudWords;
        float KeywordPercentage;
        String Percentage;
        Dot[] Dot;
        boolean toggle;
        Particle particle;
        int DotSize;
        int FontSize;
        int CloudColour;
        int CloudTextColour;
        int CloudTextLabelColour;
        int dotcolour;
        int NumberOfRemoveWordsToShow;
        float Textwidth;
        float PosX;
        float PosY;

        public void ModeCheck() {
            this.DotNum = this.mode.equals("remove") ? Affect_Browser.min((int)this.WordArray.length, (int)this.NumberOfRemoveWordsToShow) : this.WordArray.length;
        }

        public void load() {
            this.raw = Affect_Browser.this.loadStrings(this.filename);
        }

        public void AnalyseWords() {
            String[] stringArray = this.ExamineKeywords(this.mode, this.SourceText, this.raw);
            this.Words.parseArray(stringArray);
            this.WordArray = this.Words.getSortedArray();
            this.KeywordPercentage = this.Percentage(this.SourceText, stringArray);
            this.Percentage = Affect_Browser.nf((float)this.KeywordPercentage, (int)1, (int)1) + '%';
            Affect_Browser.this.textFont(Affect_Browser.this.font, this.FontSize);
            this.Textwidth = Affect_Browser.this.textWidth(this.Percentage);
            this.Textwidth /= 2.0f;
        }

        public float Percentage(String[] stringArray, String[] stringArray2) {
            float f = stringArray.length;
            float f2 = stringArray2.length;
            float f3 = f2 / f * 100.0f;
            return f3;
        }

        public String[] ExamineKeywords(String string, String[] stringArray, String[] stringArray2) {
            String string2 = Affect_Browser.join((String[])stringArray2, (String)"|");
            String[] stringArray3 = Affect_Browser.split((String)string2, (String)"|");
            String[] stringArray4 = new String[]{};
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals("match")) {
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        String string3;
                        if (stringArray[n].equals(stringArray3[n2])) {
                            stringArray4 = Affect_Browser.append((String[])stringArray4, (String)stringArray[n]);
                        } else if (n < stringArray.length - 1 && (string3 = stringArray[n] + ' ' + stringArray[n + 1]).equals(stringArray3[n2])) {
                            stringArray4 = Affect_Browser.append((String[])stringArray4, (String)string3);
                        }
                        ++n2;
                    }
                } else if (!this.find(stringArray[n], stringArray3)) {
                    stringArray4 = Affect_Browser.append((String[])stringArray4, (String)stringArray[n]);
                }
                ++n;
            }
            return stringArray4;
        }

        public boolean find(String string, String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public void CreateDots() {
            this.Dot = new Dot[this.DotNum];
            int n = 0;
            while (n < this.DotNum) {
                String string = this.WordArray[n].getWord();
                String string2 = string.substring(1);
                String string3 = string.substring(0, 1);
                string3 = string3.toUpperCase();
                String string4 = string3 + string2;
                this.Dot[n] = new Dot(this.family, string4, PApplet.parseInt((float)this.WordArray[n].getCount()), this.CloudColour, this.CloudTextColour);
                Affect_Browser.this.addSpacersToNode(this.Dot[n].particle, this.particle, this.Dot[n].frequency * Affect_Browser.this.DotSpacer);
                Affect_Browser.this.makeEdgeBetween(this.Dot[n].particle, this.particle, Affect_Browser.this.DotRestlength, Affect_Browser.this.DotStrength, Affect_Browser.this.DotDamping + Affect_Browser.this.DotDampingMultiplier * (float)this.Dot[n].frequency);
                this.Dot[n].particle.moveTo(this.particle.position().x() + Affect_Browser.this.random(-0.5f, 0.5f), this.particle.position().y() + Affect_Browser.this.random(-0.5f, 0.5f), 0.0f);
                ++n;
            }
        }

        public void Update() {
            this.PosX = this.particle.position().x();
            this.PosY = this.particle.position().y();
            if (this.DotNum > 0) {
                this.DrawDot();
                if (this.mode.equals("match")) {
                    this.DrawDotText();
                }
                this.UpdateDots();
            }
        }

        public void DrawDot() {
            Affect_Browser.this.fill(this.CloudColour);
            Affect_Browser.this.ellipse(this.PosX, this.PosY, this.DotSize, this.DotSize);
        }

        public void DrawDotText() {
            Affect_Browser.this.fill(this.CloudTextLabelColour);
            Affect_Browser.this.textFont(Affect_Browser.this.font, this.FontSize);
            Affect_Browser.this.text(this.Percentage, this.PosX - this.Textwidth, this.PosY + (float)3);
        }

        public void UpdateDots() {
            int n = 0;
            while (n < this.DotNum) {
                this.Dot[n].DrawDot();
                ++n;
            }
            n = 0;
            while (n < this.DotNum) {
                this.Dot[n].DrawText();
                ++n;
            }
        }

        private final /* synthetic */ void this() {
            this.Words = new Words();
        }

        Cloud(String string, String string2, int n, int n2, int n3, String[] stringArray) {
            this.this();
            this.DotSize = 40;
            this.FontSize = 10;
            this.NumberOfRemoveWordsToShow = 20;
            this.filename = string;
            this.family = this.filename.substring(0, this.filename.length() - 4);
            this.mode = string2;
            this.dotcolour = this.CloudColour = n;
            this.CloudTextColour = n2;
            this.CloudTextLabelColour = n3;
            this.SourceText = stringArray;
            this.word = this.family;
            this.particle = Affect_Browser.this.physics.makeParticle();
            this.PosX = this.particle.position().x();
            this.PosY = this.particle.position().y();
            this.load();
            this.AnalyseWords();
            this.ModeCheck();
            this.CreateDots();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Dot {
        String family;
        String word;
        int frequency;
        int DotSize;
        int FontSize;
        float Textwidth;
        Particle particle;
        int dotcolour;
        float transparency;
        int textcolour;
        float PosX;
        float PosY;
        int sizeMultiplier;
        int MinimumFontSize;
        int MinimumDotSize;

        public void DrawDot() {
            this.PosX = this.particle.position().x();
            this.PosY = this.particle.position().y();
            Affect_Browser.this.fill(this.dotcolour);
            Affect_Browser.this.ellipse(this.PosX, this.PosY, this.DotSize, this.DotSize);
        }

        public void DrawText() {
            Affect_Browser.this.fill(this.textcolour);
            Affect_Browser.this.textFont(Affect_Browser.this.font, this.FontSize);
            Affect_Browser.this.text(this.word, this.PosX - this.Textwidth, this.PosY + 2.0f);
        }

        private final /* synthetic */ void this() {
            this.sizeMultiplier = 8;
            this.MinimumFontSize = 6;
            this.MinimumDotSize = 36;
        }

        Dot(String string, String string2, int n, int n2, int n3) {
            this.this();
            this.family = string;
            this.word = string2;
            this.frequency = n;
            this.transparency = 10 * this.frequency + 40;
            if (this.transparency > 255.0f) {
                this.transparency = 255.0f;
            }
            float f = n2 >> 16 & 0xFF;
            float f2 = n2 >> 8 & 0xFF;
            float f3 = n2 & 0xFF;
            this.dotcolour = Affect_Browser.this.color(f, f2, f3, this.transparency);
            this.textcolour = n3;
            this.DotSize = n * this.sizeMultiplier + this.MinimumDotSize;
            this.FontSize = n + this.MinimumFontSize;
            Affect_Browser.this.textFont(Affect_Browser.this.font, this.FontSize);
            this.Textwidth = Affect_Browser.this.textWidth(this.word);
            this.Textwidth /= 2.0f;
            this.particle = Affect_Browser.this.physics.makeParticle();
            this.PosX = this.particle.position().x();
            this.PosY = this.particle.position().y();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ImageButtons
    extends Button {
        PImage base;
        PImage roll;
        PImage down;
        PImage currentimage;

        public void update() {
            this.over();
            this.pressed();
            this.currentimage = this.pressed ? this.down : (this.over ? this.roll : this.base);
        }

        public void over() {
            this.over = this.overRect(this.x, this.y, this.w, this.h);
        }

        public void display() {
            Affect_Browser.this.image(this.currentimage, this.x, this.y);
        }

        ImageButtons(int n, int n2, int n3, int n4, PImage pImage, PImage pImage2, PImage pImage3) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
            this.base = pImage;
            this.roll = pImage2;
            this.down = pImage3;
            this.currentimage = this.base;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PorterStemmer {
        public String stem(String string) {
            if (string.length() > 0) {
                char[] cArray = string.toCharArray();
                int n = 0;
                while (n < cArray.length) {
                    if (!Character.isLetter(cArray[n])) {
                        return "Invalid term";
                    }
                    ++n;
                }
            } else {
                return "No term entered";
            }
            string = this.step1a(string);
            string = this.step1b(string);
            string = this.step1c(string);
            string = this.step2(string);
            string = this.step3(string);
            string = this.step4(string);
            string = this.step5a(string);
            string = this.step5b(string);
            return string;
        }

        protected String step1a(String string) {
            if (string.endsWith("sses")) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ies")) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ss")) {
                return string;
            }
            if (string.endsWith("s")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }

        protected String step1b(String string) {
            if (string.endsWith("eed")) {
                if (this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                    return string.substring(0, string.length() - 1);
                }
                return string;
            }
            if (string.endsWith("ed") && this.containsVowel(string.substring(0, string.length() - 2))) {
                return this.step1b2(string.substring(0, string.length() - 2));
            }
            if (string.endsWith("ing") && this.containsVowel(string.substring(0, string.length() - 3))) {
                return this.step1b2(string.substring(0, string.length() - 3));
            }
            return string;
        }

        protected String step1b2(String string) {
            if (string.endsWith("at") || string.endsWith("bl") || string.endsWith("iz")) {
                return string + 'e';
            }
            if (this.endsWithDoubleConsonent(string) && !string.endsWith("l") && !string.endsWith("s") && !string.endsWith("z")) {
                return string.substring(0, string.length() - 1);
            }
            if (this.stringMeasure(string) == 1 && this.endsWithCVC(string)) {
                return string + 'e';
            }
            return string;
        }

        protected String step1c(String string) {
            if (string.endsWith("y") && this.containsVowel(string.substring(0, string.length() - 1))) {
                return string.substring(0, string.length() - 1) + 'i';
            }
            return string;
        }

        protected String step2(String string) {
            if (string.endsWith("ational") && this.stringMeasure(string.substring(0, string.length() - 5)) > 0) {
                return string.substring(0, string.length() - 5) + 'e';
            }
            if (string.endsWith("tional") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("enci") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("anci") && this.stringMeasure(string.substring(0, string.length() - 1)) > 0) {
                return string.substring(0, string.length() - 1) + 'e';
            }
            if (string.endsWith("izer") && this.stringMeasure(string.substring(0, string.length() - 1)) > 0) {
                return string.substring(0, string.length() - 1);
            }
            if (string.endsWith("abli") && this.stringMeasure(string.substring(0, string.length() - 1)) > 0) {
                return string.substring(0, string.length() - 1) + 'e';
            }
            if (string.endsWith("alli") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("entli") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("eli") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ousli") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ization") && this.stringMeasure(string.substring(0, string.length() - 5)) > 0) {
                return string.substring(0, string.length() - 5) + 'e';
            }
            if (string.endsWith("ation") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3) + 'e';
            }
            if (string.endsWith("ator") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2) + 'e';
            }
            if (string.endsWith("alism") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("iveness") && this.stringMeasure(string.substring(0, string.length() - 4)) > 0) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("fulness") && this.stringMeasure(string.substring(0, string.length() - 4)) > 0) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("ousness") && this.stringMeasure(string.substring(0, string.length() - 4)) > 0) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("aliti") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("iviti") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3) + 'e';
            }
            if (string.endsWith("biliti") && this.stringMeasure(string.substring(0, string.length() - 5)) > 0) {
                return string.substring(0, string.length() - 5) + "le";
            }
            return string;
        }

        protected String step3(String string) {
            if (string.endsWith("icate") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ative") && this.stringMeasure(string.substring(0, string.length() - 5)) > 0) {
                return string.substring(0, string.length() - 5);
            }
            if (string.endsWith("alize") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("iciti") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ical") && this.stringMeasure(string.substring(0, string.length() - 2)) > 0) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ful") && this.stringMeasure(string.substring(0, string.length() - 3)) > 0) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ness") && this.stringMeasure(string.substring(0, string.length() - 4)) > 0) {
                return string.substring(0, string.length() - 4);
            }
            return string;
        }

        protected String step4(String string) {
            if (string.endsWith("al") && this.stringMeasure(string.substring(0, string.length() - 2)) > 1) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ance") && this.stringMeasure(string.substring(0, string.length() - 4)) > 1) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("ence") && this.stringMeasure(string.substring(0, string.length() - 4)) > 1) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("er") && this.stringMeasure(string.substring(0, string.length() - 2)) > 1) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ic") && this.stringMeasure(string.substring(0, string.length() - 2)) > 1) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("able") && this.stringMeasure(string.substring(0, string.length() - 4)) > 1) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("ible") && this.stringMeasure(string.substring(0, string.length() - 4)) > 1) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("ant") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ement") && this.stringMeasure(string.substring(0, string.length() - 5)) > 1) {
                return string.substring(0, string.length() - 5);
            }
            if (string.endsWith("ment") && this.stringMeasure(string.substring(0, string.length() - 4)) > 1) {
                return string.substring(0, string.length() - 4);
            }
            if (string.endsWith("ent") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if ((string.endsWith("sion") || string.endsWith("tion")) && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ou") && this.stringMeasure(string.substring(0, string.length() - 2)) > 1) {
                return string.substring(0, string.length() - 2);
            }
            if (string.endsWith("ism") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ate") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("iti") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ous") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ive") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            if (string.endsWith("ize") && this.stringMeasure(string.substring(0, string.length() - 3)) > 1) {
                return string.substring(0, string.length() - 3);
            }
            return string;
        }

        protected String step5a(String string) {
            if (this.stringMeasure(string.substring(0, string.length() - 1)) > 1 && string.endsWith("e")) {
                return string.substring(0, string.length() - 1);
            }
            if (this.stringMeasure(string.substring(0, string.length() - 1)) == 1 && !this.endsWithCVC(string.substring(0, string.length() - 1)) && string.endsWith("e")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }

        protected String step5b(String string) {
            if (string.endsWith("l") && this.endsWithDoubleConsonent(string) && this.stringMeasure(string.substring(0, string.length() - 1)) > 1) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }

        protected boolean endsWithS(String string) {
            return string.endsWith("s");
        }

        protected boolean containsVowel(String string) {
            char[] cArray = string.toCharArray();
            int n = 0;
            while (n < cArray.length) {
                if (this.isVowel(cArray[n])) {
                    return true;
                }
                ++n;
            }
            return string.indexOf(121) > -1;
        }

        public boolean isVowel(char c) {
            return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
        }

        protected boolean endsWithDoubleConsonent(String string) {
            char c = string.charAt(string.length() - 1);
            return c == string.charAt(string.length() - 2) && !this.containsVowel(string.substring(string.length() - 2));
        }

        protected int stringMeasure(String string) {
            int n = 0;
            boolean bl = false;
            char[] cArray = string.toCharArray();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (this.isVowel(cArray[n2])) {
                    bl = true;
                } else if (bl) {
                    ++n;
                    bl = false;
                }
                ++n2;
            }
            return n;
        }

        protected boolean endsWithCVC(String string) {
            char c = ' ';
            if (string.length() < 3) {
                return false;
            }
            char c2 = string.charAt(string.length() - 1);
            char c3 = string.charAt(string.length() - 2);
            c = string.charAt(string.length() - 3);
            if (c2 == 'w' || c2 == 'x' || c2 == 'y') {
                return false;
            }
            if (this.isVowel(c2)) {
                return false;
            }
            if (!this.isVowel(c3)) {
                return false;
            }
            return !this.isVowel(c);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ThreadThing
    implements Runnable {
        Thread thread;
        String u;

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            String string = this.u;
            URL uRL = null;
            int[] nArray = new int[3];
            String[] stringArray = new String[]{};
            boolean bl = false;
            try {
                InputStream inputStream;
                uRL = new URL(string);
                if (uRL != null && (stringArray = Affect_Browser.loadStrings((InputStream)(inputStream = uRL.openStream()))) != null) {
                    bl = true;
                }
                if (bl) {
                    Affect_Browser.this.increaseSource();
                    Affect_Browser.this.SourceFiles[Affect_Browser.this.SourceFiles.length - 1].URLReceive(string, stringArray);
                    Affect_Browser.this.LoadedTextDocuments = Affect_Browser.append((String[])Affect_Browser.this.LoadedTextDocuments, (String)string);
                    Affect_Browser.this.loading = false;
                }
            }
            catch (Exception exception) {
                Affect_Browser.println((String)("URL error" + exception));
                bl = false;
                Affect_Browser.this.loading = false;
            }
        }

        public void stop() {
            this.thread = null;
        }

        public void dispose() {
            this.stop();
        }

        public ThreadThing(PApplet pApplet, String string) {
            pApplet.registerDispose((Object)this);
            this.u = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Button {
        int x;
        int y;
        int w;
        int h;
        int basecolor;
        int highlightcolor;
        int currentcolor;
        boolean over;
        boolean pressed;
        boolean JustPressed;
        boolean clicked;

        public void pressed() {
            if (this.over && Affect_Browser.this.mousePressed) {
                this.pressed = true;
                if (this.JustPressed) {
                    this.clicked = false;
                } else {
                    this.JustPressed = true;
                    this.clicked = true;
                }
            } else {
                this.pressed = false;
                this.JustPressed = false;
            }
        }

        public boolean overRect(int n, int n2, int n3, int n4) {
            return Affect_Browser.this.mouseX >= n && Affect_Browser.this.mouseX <= n + n3 && Affect_Browser.this.mouseY >= n2 && Affect_Browser.this.mouseY <= n2 + n4;
        }

        private final /* synthetic */ void this() {
            this.over = false;
            this.pressed = false;
            this.JustPressed = false;
            this.clicked = false;
        }

        Button() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class P5Properties
    extends Properties {
        public boolean getBooleanProperty(String string, boolean bl) {
            return PApplet.parseBoolean((String)this.getProperty(string, "" + bl));
        }

        public int getIntProperty(String string, int n) {
            return PApplet.parseInt((String)this.getProperty(string, "" + n));
        }

        public float getFloatProperty(String string, float f) {
            return PApplet.parseFloat((String)this.getProperty(string, "" + f));
        }

        P5Properties() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Word
    implements Comparable {
        private String txt;
        private int count;

        public String getWord() {
            return this.txt;
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void decrementCount() {
            --this.count;
        }

        public int compareTo(Object object) {
            return ((Word)object).getCount() - this.count;
        }

        private final /* synthetic */ void this() {
            this.count = 1;
        }

        Word(String string) {
            this.this();
            this.txt = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Words {
        Hashtable words;

        public void parseArray(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                this.addWord(stringArray[n]);
                ++n;
            }
        }

        public void parseText(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.addWord(string2);
            }
        }

        private final void addWord(String string) {
            Object v = this.words.get(string);
            if (v == null) {
                this.words.put(string, new Word(string));
            } else {
                Word word = (Word)v;
                word.incrementCount();
            }
        }

        public int getCountForAWord(String string) {
            Object v = this.words.get(string);
            if (v == null) {
                return 0;
            }
            return ((Word)v).getCount();
        }

        public Word[] getSortedArray() {
            Collection collection = this.words.values();
            Object[] objectArray = collection.toArray(new Word[0]);
            Arrays.sort(objectArray);
            return objectArray;
        }

        private final /* synthetic */ void this() {
            this.words = new Hashtable();
        }

        Words() {
            this.this();
        }
    }
}

