/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import processing.core.PApplet;

public class Bang
extends Controller {
    private boolean isActive = false;
    private int cnt = 0;

    public Bang(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this._myLabel = new Label(this.properties().label().toUpperCase(), this.properties().colorLabel);
    }

    protected void setup() {
        this.ignoreMousedown = true;
        this.getBoundingBox();
    }

    protected void draw(PApplet pApplet) {
        pApplet.noStroke();
        if (this.isActive) {
            pApplet.fill(this.properties().colorActive);
            ++this.cnt;
            if (this.cnt == 3) {
                this.cnt = 0;
                this.isActive = false;
            }
        } else {
            pApplet.fill(this.properties().colorForeground);
        }
        pApplet.rect(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        this._myLabel.draw(pApplet, (int)this.properties().position().x(), (int)(this.properties().position().y() + this.properties().dimension().y()) + 4, this.properties().colorLabel);
    }

    protected void setValue() {
    }

    protected void updateController() {
    }

    protected void increase() {
        this.isActive = true;
    }

    protected void decrease() {
        this.isActive = true;
    }

    protected void onClick() {
        this.isActive = true;
        this.broadcast(this._myValue);
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().boundingBox().x0() && cVector3f.x() < this.properties().boundingBox().x1() && cVector3f.y() > this.properties().boundingBox().y0() && cVector3f.y() < this.properties().boundingBox().y1();
    }

    protected void getBoundingBox() {
        this.properties().boundingBox().x0(this.properties().position().x());
        this.properties().boundingBox().y0(this.properties().position().y());
        this.properties().boundingBox().x1(this.properties().position().x() + Math.max(this.properties().dimension().x(), (float)this._myLabel.width()));
        this.properties().boundingBox().y1(this.properties().position().y() + (this.properties().dimension().y() + (float)this._myLabel.height()));
    }

    protected boolean inside(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().position().x() && cVector3f.x() < this.properties().position().x() + this.properties().dimension().x() && cVector3f.y() > this.properties().position().y() && cVector3f.y() < this.properties().position().y() + this.properties().dimension().y();
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "bang");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    protected static Bang build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addBang(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
    }
}

