/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5IOHandler;
import processing.core.PImage;

public class BitFontRenderer {
    int numFonts = 2;
    int[] characters = new int[this.numFonts];
    int[][] charWidth = new int[this.numFonts][255];
    int[] charHeight = new int[this.numFonts];
    int[][][] chars = new int[this.numFonts][][];
    int[] lineHeight = new int[this.numFonts];
    int[] wh = new int[this.numFonts];
    private PImage[] font = new PImage[this.numFonts];
    private int _myCurrentFont = 0;
    protected static final int standard58 = 0;
    protected static final int standard56 = 1;

    public BitFontRenderer() {
        this.font[0] = new PImage(ControlP5IOHandler.loadImage(this.getClass().getResource("standard58.gif")));
        this.font[1] = new PImage(ControlP5IOHandler.loadImage(this.getClass().getResource("standard56.gif")));
        this._myCurrentFont = 0;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.numFonts; ++i) {
            int n;
            this.charHeight[i] = this.font[i].height;
            this.lineHeight[i] = this.charHeight[i];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.font[i].width; ++n) {
                ++n2;
                if (this.font[i].pixels[n] != -65536) continue;
                this.charWidth[i][this.characters[i]] = n2;
                int n4 = i;
                this.characters[n4] = this.characters[n4] + 1;
                if (n2 > n3) {
                    n3 = n2;
                }
                n2 = 0;
            }
            this.chars[i] = new int[this.characters[i]][n3 * this.charHeight[i]];
            n = 0;
            for (int j = 0; j < this.characters[i]; ++j) {
                for (int k = 0; k < this.charWidth[i][j] * this.charHeight[i]; ++k) {
                    this.chars[i][j][k] = this.font[i].pixels[n + k / this.charWidth[i][j] * this.font[i].width + k % this.charWidth[i][j]];
                }
                n += this.charWidth[i][j];
            }
        }
    }

    public void setFont(int n) {
        this._myCurrentFont = n;
    }

    public int getWidth(String string) {
        int n = 0;
        if (string == null) {
            string = " ";
        }
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i) - 32;
            n += this.charWidth[this._myCurrentFont][n2];
        }
        return n;
    }

    public void setLineHeight(int n) {
        this.lineHeight[this._myCurrentFont] = n;
    }

    private void putchar(int n, int n2, int n3, int n4, boolean bl, PImage pImage, PImage pImage2) {
        int n5 = pImage.width * pImage.height;
        int n6 = this.charWidth[this._myCurrentFont][n] * this.charHeight[this._myCurrentFont];
        int n7 = n3 * pImage.width;
        for (int i = 0; i < n6; ++i) {
            int n8 = n2 + i % this.charWidth[this._myCurrentFont][n];
            int n9 = n8 + n7 + i / this.charWidth[this._myCurrentFont][n] * pImage.width;
            if (this.chars[this._myCurrentFont][n][i] != -16777216 || n8 >= pImage.width || n9 < 0 || n9 >= n5) continue;
            pImage.pixels[n9] = !bl ? n4 : -6710887;
            pImage2.pixels[n9] = -1;
        }
    }

    private void write(PImage pImage, PImage pImage2, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n' || n5 > 0 && n6 > n5) {
                n6 = 0;
                n2 += this.lineHeight[this._myCurrentFont];
            }
            if (c == '\n') continue;
            this.putchar(c - 32, n + n6, n2, n3, i == n4, pImage, pImage2);
            n6 += this.charWidth[this._myCurrentFont][c - 32];
        }
    }

    public void write(PImage pImage, String string, int n, int n2, int n3, int n4) {
        int n5 = pImage.width * pImage.height;
        PImage pImage2 = new PImage(pImage.width, pImage.height);
        for (int i = 0; i < n5; ++i) {
            pImage.pixels[i] = 0xFFFFFF;
            pImage2.pixels[i] = -16777216;
        }
        this.write(pImage, pImage2, string, n, n2, n3, n4 - 1, -1);
        pImage.mask(pImage2);
    }
}

