/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Bang;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import processing.core.PApplet;

public class Button
extends Bang {
    private boolean isActive = false;
    private int cnt = 0;

    public Button(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this._myLabel = new Label(this.properties().label().toUpperCase(), this.properties().colorLabel);
        this._myValue = this.properties().defaultValue();
    }

    protected void draw(PApplet pApplet) {
        pApplet.noStroke();
        if (this.isActive) {
            pApplet.fill(this.properties().colorActive);
            ++this.cnt;
            if (this.cnt == 3) {
                this.cnt = 0;
                this.isActive = false;
            }
        } else {
            pApplet.fill(this.properties().colorForeground);
        }
        pApplet.rect(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        this._myLabel.draw(pApplet, (int)(this.properties().position().x() + this.properties().dimension().x() / 2.0f - (float)(this._myLabel.width() / 2)), (int)(this.properties().position().y() + this.properties().dimension().y() / 2.0f) - 4, this.properties().colorLabel);
    }

    protected void onRelease() {
        this.isActive = true;
        this.broadcast(this._myValue);
    }

    protected void onClick() {
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "button");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    protected static Bang build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addButton(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("value"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
    }
}

