/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Bang;
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5Constants;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.ControlWindowKeyHandler;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerList;
import controlP5.ControllerPlug;
import controlP5.ControllerProperties;
import controlP5.DropEvent;
import controlP5.Knob;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.Radio;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textfield;
import controlP5.Toggle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public class ControlP5
implements ControlP5Constants {
    public static final String VERSION = "0.1.1";
    protected int _myCurrentController = 0;
    protected ControllerList _myControllerList;
    protected String _myFilePath = "controlP5.xml";
    protected String _myUrlPath = "";
    private Hashtable _myControlWindowTable = new Hashtable();
    private Vector _myControlWindowList = new Vector();
    private int _myControlEventType = -1;
    private ControllerPlug _myControlEventPlug = null;
    private int _myDropEventType = -1;
    private ControllerPlug _myDropEventPlug = null;
    private ArrayList _myControllerPlugList = new ArrayList();
    protected static boolean isApplet = false;
    protected final ControlWindow controlWindow;
    protected static ControlWindowKeyHandler keyHandler;
    protected static boolean isLock;
    protected int colorBackground = -11447983;
    protected int colorForeground = -6711040;
    protected int colorActive = -3355648;
    protected int colorLabel = -1;
    protected int colorValue = -1;
    public static PApplet papplet;

    public ControlP5(PApplet pApplet) {
        papplet = pApplet;
        this.welcome();
        DropEvent.controlP5 = this;
        ControllerProperties.controlP5 = this;
        PAppletWindow.controlP5 = this;
        this._myControllerList = new ControllerList();
        this.clear();
        keyHandler = new ControlWindowKeyHandler(this);
        this.controlWindow = this.setWindow(papplet, "default");
        papplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        this.plug("", "controlEvent");
        this.plug("", "dropEvent");
    }

    private void welcome() {
        System.out.println("ControlP5 0.1.1 infos, comments, questions at http://www.sojamo.de/controlP5\n\n");
    }

    public ControlWindow addControlWindow(String string, int n, int n2) {
        return this.addControlWindow(string, 100, 100, n, n2);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4) {
        if (this._myControlWindowTable.containsKey(string)) {
            System.out.println("### WARNING ###\n### ControlWindow with name " + string + " already exists. overwritten!");
        }
        PAppletWindow pAppletWindow = new PAppletWindow(string, n, n2, n3, n4);
        ControlWindow controlWindow = this.setWindow(pAppletWindow, "default");
        this._myControlWindowTable.put(string, controlWindow);
        return controlWindow;
    }

    public ControlWindow setWindow(ControlWindow controlWindow, String string) {
        return this.setWindow(controlWindow.papplet(), string);
    }

    public ControlWindow setWindow(PApplet pApplet, String string) {
        boolean bl = false;
        ControlWindow controlWindow = null;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            controlWindow = (ControlWindow)enumeration.nextElement();
            if (!controlWindow.equals(pApplet)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            controlWindow = new ControlWindow(this, pApplet);
            this._myControlWindowList.add(controlWindow);
        }
        return controlWindow;
    }

    public ControlWindow window(String string) {
        if (this._myControlWindowTable.containsKey(string)) {
            return (ControlWindow)this._myControlWindowTable.get(string);
        }
        System.out.println("### WARNING ###\n### ControlWindow " + string + " does not exist. returning null.");
        return null;
    }

    public ControlWindow window(PApplet pApplet) {
        ControlWindow controlWindow = null;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            controlWindow = (ControlWindow)enumeration.nextElement();
            if (!controlWindow.equals(pApplet)) continue;
            return controlWindow;
        }
        return controlWindow;
    }

    public ControlWindow window(ControlWindow controlWindow) {
        return controlWindow;
    }

    public Controller controller(String string) {
        return this._myControllerList.get(string);
    }

    public Slider addSlider(String string, float f, float f2, float f3, float f4, float f5, int n, int n2) {
        Slider slider = new Slider(new ControllerProperties(string, f, f2, f3, f4, f5, n, n2));
        this.add(slider);
        return slider;
    }

    public Slider addSlider(String string, float f, float f2, float f3, float f4, int n, int n2) {
        Slider slider = new Slider(new ControllerProperties(string, f, f2, Float.NaN, f3, f4, n, n2));
        this.add(slider);
        return slider;
    }

    public Knob addKnob(String string, float f, float f2, float f3, float f4, int n) {
        return this.addKnob(string, f, f2, Float.NaN, f3, f4, n);
    }

    public Knob addKnob(String string, float f, float f2, float f3, float f4, float f5, int n) {
        Knob knob = new Knob(new ControllerProperties(string, f, f2, f3, f4, f5, n, n));
        this.add(knob);
        return knob;
    }

    public Toggle addToggle(String string, boolean bl, float f, float f2, int n, int n2) {
        Toggle toggle = new Toggle(new ControllerProperties(string, 0.0f, 1.0f, bl ? 1.0f : 0.0f, f, f2, n, n2));
        this.add(toggle);
        return toggle;
    }

    public Toggle addToggle(String string, float f, float f2, int n, int n2) {
        Toggle toggle = new Toggle(new ControllerProperties(string, 0.0f, 1.0f, Float.NaN, f, f2, n, n2));
        this.add(toggle);
        return toggle;
    }

    public Numberbox addNumberbox(String string, float f, float f2, int n, int n2) {
        return this.addNumberbox(string, Float.NaN, f, f2, n, n2);
    }

    public Numberbox addNumberbox(String string, float f, float f2, float f3, int n, int n2) {
        Numberbox numberbox = new Numberbox(new ControllerProperties(string, -1000000.0f, 1000000.0f, f, f2, f3, n, n2));
        this.add(numberbox);
        return numberbox;
    }

    public Bang addBang(String string, float f, float f2, int n, int n2) {
        Bang bang = new Bang(new ControllerProperties(string, 1.0f, 1.0f, 1.0f, f, f2, n, n2));
        this.add(bang);
        return bang;
    }

    public Button addButton(String string, float f, float f2, float f3, int n, int n2) {
        Button button = new Button(new ControllerProperties(string, -1.0E7f, 1.0E7f, f, f2, f3, n, n2));
        this.add(button);
        return button;
    }

    public Textfield addTextfield(String string, float f, float f2, int n, int n2) {
        Textfield textfield = new Textfield(new ControllerProperties(string, 1.0f, 1.0f, 1.0f, f, f2, n, n2));
        this.add(textfield);
        return textfield;
    }

    public Radio addRadio(String string, float f, float f2) {
        Radio radio = new Radio(new ControllerProperties(string, 1.0f, 1.0f, 1.0f, f, f2, 0, 0));
        this.add(radio);
        return radio;
    }

    public Controller add(Controller controller) {
        if (controller.name().indexOf(32) != -1) {
            System.out.println("### WARNING ###\n### controller name contains spaces. please try to avoid spaces.\n### use the setLabel() method for labeling a controller.\n");
        }
        this.checkName(controller);
        this._myControllerList.add(controller);
        this.plug(controller.name(), controller.name());
        controller.setWindow(papplet);
        controller.start();
        return controller;
    }

    private void checkName(Controller controller) {
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            if (!controller.name().equals(this._myControllerList.get(i).name())) continue;
            System.out.println("### WARNING ###\n### controller name " + controller.name() + " already exists.\n" + "### please try to use a unique name for each controller.\n" + "### use the setLabel() method for labeling a controller.\n");
        }
    }

    protected void add(ControllerList controllerList) {
        for (int i = 0; i < controllerList.size(); ++i) {
            this.add(controllerList.get(i));
        }
    }

    public Tab addTab(PApplet pApplet, String string) {
        return this.setWindow(pApplet, string).addTab(string);
    }

    public Tab addTab(ControlWindow controlWindow, String string) {
        return this.setWindow(controlWindow, string).addTab(string);
    }

    public void setFilePath(String string) {
        if (string == null) {
            string = "";
        }
        this._myFilePath = string;
    }

    public void setUrlPath(String string) {
        this.setUrlPath(string, "controlP5.xml");
    }

    public void setUrlPath(String string, String string2) {
        if (string == null) {
            string = "";
            return;
        }
        if ((string = ControlP5IOHandler.replace(string, "&amp;", "&")).indexOf(63) == -1) {
            string = string + '?';
        } else if (!string.endsWith("&") && !string.endsWith("?")) {
            string = string + "&";
        }
        this._myUrlPath = string + "filename=" + string2;
    }

    public String filePath() {
        return this._myFilePath;
    }

    public String urlPath() {
        return this._myUrlPath;
    }

    public ControllerList controllerList() {
        return this._myControllerList;
    }

    protected void setValue(Controller controller, String string, float f) {
        if (controller.properties().isControllerPlug) {
            this.callTarget(string, f);
        }
        if (this._myControlEventType == 0) {
            this.invokeMethod(this._myControlEventPlug.object(), this._myControlEventPlug.getMethod(), new Object[]{new ControlEvent(controller)});
        }
    }

    protected void setValue(Controller controller, String string, String string2) {
        if (controller.properties().isControllerPlug) {
            this.callTarget(string, string2);
        }
        if (this._myControlEventType == 0) {
            this.invokeMethod(this._myControlEventPlug.object(), this._myControlEventPlug.getMethod(), new Object[]{new ControlEvent(controller)});
        }
    }

    public void clear() {
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            ((ControlWindow)this._myControlWindowList.get(i)).clear();
        }
        this._myControllerPlugList.clear();
        this._myControlWindowTable.clear();
        this._myControlWindowList.clear();
        this._myControllerList.clear();
    }

    public Controller current() {
        return this._myControllerList.get(this._myCurrentController);
    }

    public String dumpAll() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            stringBuffer.append(this._myControllerList.get(i).toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public void resetCurrentControllerToDefault() {
        this._myControllerList.get(this._myCurrentController).reset();
    }

    public void increaseCurrentController() {
        this._myControllerList.get(this._myCurrentController).increase();
        this._myControllerList.get(this._myCurrentController).broadcast(this._myControllerList.get(this._myCurrentController).value());
        this.updateControlWindows();
    }

    private void updateControlWindows() {
        for (int i = 0; i < this._myControlWindowList.size(); ++i) {
            ((ControlWindow)this._myControlWindowList.get(i)).forcePost();
        }
    }

    public void decreaseCurrentController() {
        this._myControllerList.get(this._myCurrentController).decrease();
        this._myControllerList.get(this._myCurrentController).broadcast(this._myControllerList.get(this._myCurrentController).value());
        this.updateControlWindows();
    }

    protected void switchToNextController() {
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            ++this._myCurrentController;
            this._myCurrentController %= this._myControllerList.size();
            if (this._myControllerList.get(this._myCurrentController) instanceof Textfield) continue;
            this._myControllerList.get(this._myCurrentController).window().activate(this._myControllerList.get(this._myCurrentController).tab());
            break;
        }
    }

    protected void switchToPreviousController() {
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            --this._myCurrentController;
            if (this._myCurrentController >= 0) continue;
            this._myCurrentController = this._myControllerList.size() - 1;
            if (this._myControllerList.get(this._myCurrentController) instanceof Textfield) continue;
            this._myControllerList.get(this._myCurrentController).window().activate(this._myControllerList.get(this._myCurrentController).tab());
            break;
        }
    }

    public void plug(Controller controller, String string) {
        this.plug(controller.name(), string);
    }

    public void plug(String string, String string2) {
        if (string2.equals("controlEvent")) {
            this._myControlEventPlug = ControlP5.checkObject(papplet, "controlEvent", new Class[]{ControlEvent.class});
            if (this._myControlEventPlug != null) {
                this._myControlEventType = 0;
            }
            return;
        }
        if (string2.equals("dropEvent")) {
            this._myDropEventPlug = ControlP5.checkObject(papplet, "dropEvent", new Class[]{DropEvent.class});
            if (this._myDropEventPlug != null) {
                this._myDropEventType = 0;
            }
            return;
        }
        Controller controller = this.controller(string);
        if (controller != null) {
            controller.properties().setTarget(string2);
            controller.properties().setTargetObject(papplet);
            ControllerPlug controllerPlug = ControlP5.checkObject(papplet, string2, ControlP5Constants.acceptClassList);
            if (controllerPlug != null) {
                if (controller.properties().controllerPlug() == null) {
                    this._myControllerPlugList.add(controllerPlug);
                    controller.properties().setControllerPlug(controllerPlug);
                } else {
                    controller.properties().controllerPlug().set(controllerPlug.object(), controllerPlug.name(), controllerPlug.type(), controllerPlug.parameterType(), ControlP5Constants.acceptClassList);
                }
            }
        } else {
            System.out.println("### Controller " + string + " does not exist.");
        }
    }

    public static ControllerPlug checkObject(Object object, String string, Class[] classArray) {
        int n;
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            if (methodArray[i].getParameterTypes().length == 1) {
                for (n = 0; n < classArray.length; ++n) {
                    if (methodArray[i].getParameterTypes()[0] != classArray[n]) continue;
                    return new ControllerPlug(object, string, 0, n, classArray);
                }
                break;
            }
            if (methodArray[i].getParameterTypes().length != 0) break;
            return new ControllerPlug(object, string, 0, -1, classArray);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            if (!fieldArray[n].getName().equals(string)) continue;
            for (int i = 0; i < classArray.length; ++i) {
                if (fieldArray[n].getType() != classArray[i]) continue;
                return new ControllerPlug(object, string, 1, i, classArray);
            }
            break;
        }
        return null;
    }

    private void callTarget(String string, float f) {
        for (int i = 0; i < this._myControllerPlugList.size(); ++i) {
            if (!((ControllerPlug)this._myControllerPlugList.get(i)).checkName(string)) continue;
            ControllerPlug controllerPlug = (ControllerPlug)this._myControllerPlugList.get(i);
            if (controllerPlug.checkType(0)) {
                this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), controllerPlug.getMethodParameter(f));
                continue;
            }
            if (!controllerPlug.checkType(1)) continue;
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), controllerPlug.getFieldParameter(f));
        }
    }

    private void callTarget(String string, String string2) {
        for (int i = 0; i < this._myControllerPlugList.size(); ++i) {
            if (!((ControllerPlug)this._myControllerPlugList.get(i)).checkName(string)) continue;
            ControllerPlug controllerPlug = (ControllerPlug)this._myControllerPlugList.get(i);
            if (controllerPlug.checkType(0)) {
                this.invokeMethod(controllerPlug.object(), controllerPlug.getMethod(), new Object[]{string2});
                continue;
            }
            if (!controllerPlug.checkType(1)) continue;
            this.invokeField(controllerPlug.object(), controllerPlug.getField(), string2);
        }
    }

    protected void invokeDropEvent(DropEvent dropEvent) {
        if (this._myDropEventType == 0) {
            this.invokeMethod(this._myDropEventPlug.object(), this._myDropEventPlug.getMethod(), new Object[]{dropEvent});
        }
        dropEvent._myImage = null;
        System.gc();
    }

    private void invokeField(Object object, Field field, Object object2) {
        block2: {
            try {
                field.set(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (isApplet) break block2;
                System.out.println("### WARNING @ ControlP5.invokeField " + illegalAccessException);
            }
        }
    }

    private void invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            if (objectArray[0] == null) {
                method.invoke(object, new Object[0]);
            } else {
                method.invoke(object, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            this.printMethodError(method, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.printMethodError(method, invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            this.printMethodError(method, nullPointerException);
        }
    }

    private void printMethodError(Method method, Exception exception) {
        System.out.println("ERROR. an error occured while forwarding a Controller value\n to a method in your program. please check your code for any \npossible errors that might occur in this method .\n e.g. check for casting errors, possible nullpointers, array overflows ... .\nmethod: " + method.getName() + "\n" + "exception:  " + exception);
    }

    public boolean load() {
        if (this._myFilePath != null) {
            return this.load(this._myFilePath);
        }
        return false;
    }

    public boolean load(String string) {
        return this.load(string, true);
    }

    public boolean loadUrl(String string) {
        String string2 = "";
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.connect();
            string = string.replaceAll("%20", " ");
            String[] stringArray = string.split("/");
            String string3 = stringArray[stringArray.length - 1];
            InputStream inputStream = httpURLConnection.getInputStream();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                int n2;
                byte[] byArray = new byte[16384];
                System.out.println("Ready to download " + string3 + " " + httpURLConnection.getContentLength() + " bytes");
                int n3 = 0;
                int n4 = httpURLConnection.getContentLength();
                while ((n2 = inputStream.read(byArray)) > 0) {
                    n3 += n2;
                    string2 = string2 + new String(byArray);
                }
            }
            httpURLConnection.disconnect();
        }
        catch (IOException iOException) {
            System.out.println("Exception\n" + iOException);
        }
        return this.parse(string2, true);
    }

    private boolean load(String string, boolean bl) {
        String[] stringArray;
        try {
            stringArray = papplet.loadStrings(string);
        }
        catch (Exception exception) {
            System.out.println("PROBLEMS loading file " + string + ". make sure the file exists.");
            return false;
        }
        if (stringArray == null) {
            System.out.println("PROBLEMS loading file " + string + " either file does not exist or is empty.");
            return false;
        }
        this.clear();
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
        }
        return this.parse(string2, bl);
    }

    private boolean parse(String string, boolean bl) {
        try {
            ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement();
            controlP5XMLElement.parseString(string);
            if (bl) {
                this.clear();
            }
            Vector vector = controlP5XMLElement.getChildren();
            this._myFilePath = controlP5XMLElement.getStringAttribute("filepath");
            this._myUrlPath = controlP5XMLElement.getStringAttribute("urlpath");
            isLock = controlP5XMLElement.getStringAttribute("lock").equals("true");
            this.colorBackground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorBackground"));
            this.colorForeground = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorForeground"));
            this.colorActive = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorActive"));
            this.colorLabel = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorLabel"));
            this.colorValue = ControlP5IOHandler.parseHex(controlP5XMLElement.getStringAttribute("colorValue"));
            for (int i = 0; i < vector.size(); ++i) {
                PApplet pApplet;
                Object object;
                ControlP5XMLElement controlP5XMLElement2 = (ControlP5XMLElement)vector.get(i);
                if (controlP5XMLElement2.getStringAttribute("class").startsWith("controlP5.PAppletWindow")) {
                    object = this.addControlWindow(controlP5XMLElement2.getStringAttribute("name"), controlP5XMLElement2.getIntAttribute("x"), controlP5XMLElement2.getIntAttribute("y"), controlP5XMLElement2.getIntAttribute("width"), controlP5XMLElement2.getIntAttribute("height"));
                    ((ControlWindow)object).setBackground(ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("background")));
                    pApplet = ((ControlWindow)object).papplet();
                } else {
                    pApplet = papplet;
                    this.controlWindow.setBackground(ControlP5IOHandler.parseHex(controlP5XMLElement2.getStringAttribute("background")));
                    this._myControlWindowList.add(this.controlWindow);
                }
                object = controlP5XMLElement2.getChildren();
                String string2 = "default";
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    ControlP5XMLElement controlP5XMLElement3 = (ControlP5XMLElement)((Vector)object).get(j);
                    string2 = controlP5XMLElement3.getStringAttribute("name");
                    Tab tab = this.addTab(pApplet, string2);
                    Vector vector2 = controlP5XMLElement3.getChildren();
                    for (int k = 0; k < vector2.size(); ++k) {
                        ControlP5XMLElement controlP5XMLElement4 = (ControlP5XMLElement)vector2.get(k);
                        Controller controller = null;
                        if (controlP5XMLElement4.getStringAttribute("type").equals("slider")) {
                            controller = Slider.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("knob")) {
                            controller = Knob.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("bang")) {
                            controller = Bang.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("radio")) {
                            controller = Radio.build(this, controlP5XMLElement4);
                            Vector vector3 = controlP5XMLElement4.getChildren();
                            for (int i2 = 0; i2 < vector3.size(); ++i2) {
                                ControlP5XMLElement controlP5XMLElement5 = (ControlP5XMLElement)vector3.get(i2);
                                String string3 = controlP5XMLElement5.getStringAttribute("name");
                                int n = (int)controlP5XMLElement5.getDoubleAttribute("value");
                                Radio.RadioButton radioButton = ((Radio)controller).add(string3, n);
                                if (controlP5XMLElement5.getIntAttribute("state") != 1) continue;
                                ((Radio)controller).activate(radioButton.name());
                            }
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("toggle")) {
                            controller = Toggle.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("textfield")) {
                            controller = Textfield.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("numberbox")) {
                            controller = Numberbox.build(this, controlP5XMLElement4);
                        } else if (controlP5XMLElement4.getStringAttribute("type").equals("button")) {
                            controller = Button.build(this, controlP5XMLElement4);
                        }
                        if (controller != null) {
                            controller.setWindow(pApplet, tab.name());
                            this.plug(controller, controlP5XMLElement4.getStringAttribute("target"));
                            controller.setLabel(controlP5XMLElement4.getStringAttribute("label"));
                            controller.setColorBackground(ControlP5IOHandler.parseHex(controlP5XMLElement4.getStringAttribute("colorBackground")));
                            controller.setColorForeground(ControlP5IOHandler.parseHex(controlP5XMLElement4.getStringAttribute("colorForeground")));
                            controller.setColorActive(ControlP5IOHandler.parseHex(controlP5XMLElement4.getStringAttribute("colorActive")));
                            controller.setColorLabel(ControlP5IOHandler.parseHex(controlP5XMLElement4.getStringAttribute("colorLabel")));
                            controller.setColorValue(ControlP5IOHandler.parseHex(controlP5XMLElement4.getStringAttribute("colorValue")));
                            continue;
                        }
                        System.out.println("### ERROR controller element not parseable. " + controlP5XMLElement4);
                    }
                }
            }
            this.controlWindow.tab().activate(true);
            return true;
        }
        catch (Exception exception) {
            System.out.println("ERROR unable to parse file. make sure the file exists. " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public boolean save(String string) {
        Object object;
        Object object2;
        Object object3;
        String string2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controlP5");
        Calendar calendar = Calendar.getInstance();
        controlP5XMLElement.setAttribute("date", calendar.getTime().toString());
        controlP5XMLElement.setAttribute("filepath", this._myFilePath);
        controlP5XMLElement.setAttribute("urlpath", this._myUrlPath);
        controlP5XMLElement.setAttribute("lock", "" + isLock);
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.colorValue));
        Object object4 = this._myControlWindowList.elements();
        while (object4.hasMoreElements()) {
            object3 = (ControlWindow)object4.nextElement();
            object2 = ((ControlWindow)object3).tabs();
            object = ((ControlWindow)object3).getAsXML();
            Enumeration enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                Tab tab = (Tab)enumeration.nextElement();
                ControlP5XMLElement controlP5XMLElement2 = tab.getAsXML();
                ControllerList controllerList = tab.controllerList();
                for (int i = 0; i < controllerList.size(); ++i) {
                    controlP5XMLElement2.addChild(controllerList.get(i).getAsXML());
                }
                ((ControlP5XMLElement)object).addChild(controlP5XMLElement2);
            }
            controlP5XMLElement.addChild((ControlP5XMLElement)object);
        }
        if (this._myUrlPath.toLowerCase().startsWith("http://") || this._myUrlPath.toLowerCase().startsWith("https://")) {
            try {
                object4 = new URL(this._myUrlPath);
                object3 = ((URL)object4).openConnection();
                ((HttpURLConnection)object3).setRequestMethod("POST");
                ((URLConnection)object3).setDoInput(true);
                ((URLConnection)object3).setDoOutput(true);
                object2 = new OutputStreamWriter(((URLConnection)object3).getOutputStream());
                ((Writer)object2).write("controlP5=" + ControlP5IOHandler.forURL(string2 + ControlP5IOHandler.replace(controlP5XMLElement.toString(), ">", ">\n")));
                ((OutputStreamWriter)object2).flush();
                ((OutputStreamWriter)object2).close();
                object = new BufferedReader(new InputStreamReader(((URLConnection)object3).getInputStream()));
                while (((BufferedReader)object).ready()) {
                    System.out.println(((BufferedReader)object).readLine());
                }
                System.out.println("uploading xml to " + this._myUrlPath + " .");
            }
            catch (Exception exception) {
                System.out.println("### ERROR ###\n### Error while uploading xml to " + this._myUrlPath + " " + exception);
            }
        }
        try {
            if (!ControlP5.papplet.online) {
                if (string.length() > 1) {
                    if (!string.startsWith("data/") && string.indexOf(47) == -1 && string.indexOf(92) == -1) {
                        string = "data/" + string;
                    }
                    papplet.saveStrings(string, new String[]{string2, ControlP5IOHandler.replace(controlP5XMLElement.toString(), ">", ">\n")});
                    System.out.println("### ControlP5 . writing file " + string + " to disk.");
                } else {
                    System.out.println("### ERROR ###\n### Please specify a filepath in order to save settings to xml.");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("### WARNING ###\n### did not write to file " + string + " because of exception " + exception);
        }
        return true;
    }

    public boolean save() {
        if (this._myFilePath != null) {
            return this.save(this._myFilePath);
        }
        return false;
    }

    public String version() {
        return VERSION;
    }

    public void draw() {
        this.window(papplet).post();
    }

    public void background(int n) {
        this.controlWindow.setBackground(n);
    }

    public void lock() {
        isLock = true;
    }

    public void unlock() {
        isLock = false;
    }

    public void show() {
        this.window(papplet).show();
    }

    public void hide() {
        this.window(papplet).hide();
    }

    public void setColorActive(int n) {
        this.colorActive = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.colorForeground = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.colorBackground = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.colorLabel = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.colorValue = n;
        Enumeration enumeration = this._myControlWindowList.elements();
        while (enumeration.hasMoreElements()) {
            ControlWindow controlWindow = (ControlWindow)enumeration.nextElement();
            controlWindow.setColorValue(n);
        }
    }

    public void updateControllers() {
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).broadcast(this._myControllerList.get(i).value());
        }
    }

    static {
        isLock = false;
    }
}

