/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;

public class ControlP5IOHandler {
    public static Image loadImage(URL uRL) {
        Image image = null;
        image = Toolkit.getDefaultToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker((Component)ControlP5.papplet);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        return image;
    }

    public static String forURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return string2;
    }

    public static String forHTMLTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\\') {
                stringBuffer.append("&#092;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    String URLEncode(String string) {
        String string2 = new String();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 0) continue;
                string2 = byArray[i] == 32 ? string2 + '+' : string2 + (char)byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.length() < 1) {
            return "";
        }
        for (int i = 0; i < string.length() && (i = string.indexOf(string2, i)) >= 0; i += string3.length()) {
            string = string.substring(0, i) + string3 + string.substring(i + string2.length(), string.length());
        }
        return string;
    }

    public static int parseHex(String string) {
        int n = string.length();
        switch (n) {
            case 8: {
                break;
            }
            case 6: {
                string = "ff" + string;
                break;
            }
            default: {
                string = "ff000000";
            }
        }
        int n2 = new Integer(Integer.parseInt(string.substring(0, 2), 16));
        int n3 = new Integer(Integer.parseInt(string.substring(2, 4), 16));
        int n4 = new Integer(Integer.parseInt(string.substring(4, 6), 16));
        int n5 = new Integer(Integer.parseInt(string.substring(6, 8), 16));
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static String intToString(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        String string = Integer.toHexString(n2).length() == 1 ? "0" + Integer.toHexString(n2) : Integer.toHexString(n2);
        String string2 = Integer.toHexString(n3).length() == 1 ? "0" + Integer.toHexString(n3) : Integer.toHexString(n3);
        String string3 = Integer.toHexString(n4).length() == 1 ? "0" + Integer.toHexString(n4) : Integer.toHexString(n4);
        String string4 = Integer.toHexString(n5).length() == 1 ? "0" + Integer.toHexString(n5) : Integer.toHexString(n5);
        return string + string2 + string3 + string4;
    }
}

