/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindowKeyListener;
import controlP5.DropListener;
import controlP5.Label;
import controlP5.PAppletWindow;
import controlP5.Tab;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public class ControlWindow {
    PApplet _myApplet;
    Vector _myTabs;
    int _myActiveTab = 0;
    protected int colorBackground = -11447983;
    protected int colorForeground = -8947968;
    protected int colorActive = -256;
    protected int colorLabel = -1;
    protected int colorValue = -1;
    protected int background = 0;
    protected boolean isShow = true;
    private boolean isKeyMenu = false;
    private Label _myKeyMenuLabel;
    private String _myName = "main";
    private boolean isPAppletWindow = false;
    protected final ControlP5 controlP5;
    private boolean isClear = false;
    private static Label _myKeyMenuTitle;

    public ControlWindow(ControlP5 controlP5, PApplet pApplet) {
        this.controlP5 = controlP5;
        this._myApplet = pApplet;
        if (this._myApplet instanceof PAppletWindow) {
            this._myName = ((PAppletWindow)pApplet).name();
            this.isPAppletWindow = true;
        }
        if (this.isPAppletWindow) {
            this.background = -16777216;
        }
        this.colorForeground = this.controlP5.colorForeground;
        this.colorBackground = this.controlP5.colorBackground;
        this.colorActive = this.controlP5.colorActive;
        this.colorLabel = this.controlP5.colorLabel;
        this.colorValue = this.controlP5.colorValue;
        new DropTarget((Component)this._myApplet, new DropListener());
        this._myTabs = new Vector();
        this._myTabs.add(new Tab(this, "default", 0));
        this._myKeyMenuLabel = new Label("keymenu", 200, 20, -16777216);
        this._myKeyMenuLabel.set("Use ALT + ARROW KEYS");
        _myKeyMenuTitle = new Label("ControlP5 KEY CONTROL", 200, 20, -1);
        this._myApplet.registerMouseEvent((Object)this);
        if (this._myApplet instanceof PAppletWindow) {
            this._myApplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
        } else {
            ControlP5.keyHandler.update(this);
        }
        ((Tab)this._myTabs.get(0)).activate(true);
        if (this._myApplet.g.getClass().getName().indexOf("PGraphics2D") > -1 || this._myApplet.g.getClass().getName().indexOf("PGraphics3D") > -1) {
            System.out.println("### INFO you are using renderer " + this._myApplet.g.getClass().getName() + "\n" + "to draw controlP5 you have to call the controlP5.draw() method inside of\n" + "your processing sketch draw() method.");
        } else {
            this._myApplet.registerPost((Object)this);
        }
    }

    public String name() {
        return this._myName;
    }

    public Tab tab() {
        return (Tab)this._myTabs.get(0);
    }

    public Tab tab(int n) {
        return (Tab)this._myTabs.get(n);
    }

    public Tab tab(String string) {
        return this.addTab(string);
    }

    public Vector tabs() {
        return this._myTabs;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public Tab addTab(String string) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).name().equals(string)) continue;
            return (Tab)this._myTabs.get(i);
        }
        Tab tab = new Tab(this, string, this._myTabs.size());
        this._myTabs.add(tab);
        return tab;
    }

    public void removeTab(String string) {
        Tab tab = null;
        Enumeration enumeration = this._myTabs.elements();
        while (enumeration.hasMoreElements()) {
            tab = (Tab)enumeration.nextElement();
            if (!tab.name().equals(string)) continue;
            tab.clear();
            this._myTabs.remove(tab);
            break;
        }
    }

    protected void clear() {
        this.isKeyMenu = false;
        Tab tab = null;
        Enumeration enumeration = this._myTabs.elements();
        while (enumeration.hasMoreElements()) {
            tab = (Tab)enumeration.nextElement();
            tab.clear();
        }
        this._myTabs.clear();
        if (this._myApplet instanceof PAppletWindow) {
            this.isClear = true;
            this._myApplet.loop();
        }
    }

    public void setColorActive(int n) {
        this.colorActive = n;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.colorForeground = n;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.colorBackground = n;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.colorLabel = n;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.colorValue = n;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).setColorValue(n);
        }
    }

    public boolean equals(PApplet pApplet) {
        return this._myApplet.equals(pApplet);
    }

    public void post() {
        if (this.isClear) {
            ((PAppletWindow)this._myApplet).dispose();
            this._myApplet = null;
            System.gc();
        } else {
            if (this.isShow) {
                if ((this.background >> 24 & 0xFF) > 0) {
                    this._myApplet.fill(this.background);
                    this._myApplet.rect(0.0f, 0.0f, (float)this._myApplet.width, (float)this._myApplet.height);
                }
                boolean bl = this._myTabs.size() > 1;
                for (int i = 0; i < this._myTabs.size(); ++i) {
                    ((Tab)this._myTabs.get(i)).update(this._myApplet, bl);
                    ((Tab)this._myTabs.get(i)).draw(this._myApplet, bl);
                }
            }
            if (this.isKeyMenu) {
                this._myApplet.noStroke();
                this._myApplet.fill(-16777216);
                this._myApplet.rect((float)(this._myApplet.width / 2 - 100), (float)(this._myApplet.height / 2 - 45), 200.0f, 20.0f);
                _myKeyMenuTitle.draw(this._myApplet, this._myApplet.width / 2 - 100 + 8, this._myApplet.height / 2 - 38);
                this._myApplet.fill(-1996488705);
                this._myApplet.rect((float)(this._myApplet.width / 2 - 100), (float)(this._myApplet.height / 2 - 25), 200.0f, 50.0f);
                this._myKeyMenuLabel.draw(this._myApplet, this._myApplet.width / 2 - 100 + 8, this._myApplet.height / 2 - 25 + 5);
            }
        }
    }

    protected void forcePost() {
        if (!(this._myApplet instanceof PAppletWindow) || !((PAppletWindow)this._myApplet).isLoop) {
            // empty if block
        }
    }

    protected void keyMenuText(String string) {
        this._myKeyMenuLabel.set(string.toUpperCase());
    }

    protected void activate(Tab tab) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).activate(false);
            if (!((Tab)this._myTabs.get(i)).equals(tab)) continue;
            ((Tab)this._myTabs.get(i)).activate(true);
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).mouseEvent(mouseEvent);
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).keyEvent(keyEvent);
        }
    }

    public void hide() {
        this.isShow = false;
    }

    public void show() {
        this.isShow = true;
    }

    protected void keyMenu(boolean bl) {
        this.isKeyMenu = bl;
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("window");
        controlP5XMLElement.setAttribute("class", this.papplet().getClass().getName());
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("width", "" + this.papplet().width);
        controlP5XMLElement.setAttribute("height", "" + this.papplet().height);
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.colorValue));
        controlP5XMLElement.setAttribute("background", ControlP5IOHandler.intToString(this.background));
        if (this.papplet().getClass().getName().indexOf("controlP5.PAppletWindow") != -1) {
            controlP5XMLElement.setAttribute("x", "" + ((PAppletWindow)this.papplet()).x);
            controlP5XMLElement.setAttribute("y", "" + ((PAppletWindow)this.papplet()).y);
        }
        return controlP5XMLElement;
    }

    public void setBackground(int n) {
        this.background = n;
    }
}

