/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.ControllerProperties;
import controlP5.Label;
import controlP5.Tab;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import processing.core.PApplet;

public abstract class Controller
implements ControlP5Constants {
    private ControllerProperties properties;
    protected boolean isActive;
    protected boolean isInitialized;
    protected boolean ignoreMousedown = false;
    protected float _myValue;
    protected String _myStringValue = "";
    protected ControlWindow _myControlWindow;
    protected CVector3f _myMousePosition = new CVector3f();
    protected CVector3f _myPreviousMousePosition = new CVector3f();
    protected boolean isMousePressed = false;
    protected boolean isMouseDown = false;
    protected boolean isInside = false;
    protected boolean isInsideBoundingBox = false;
    protected String _myTabName;
    protected Label _myLabel;
    protected Label _myValueLabel;
    protected int _myId = -1;

    public Controller(ControllerProperties controllerProperties) {
        this.properties = controllerProperties;
        this.properties().init(this);
    }

    protected void start() {
        if (this.properties().controllerPlug() != null) {
            if (Float.isNaN(this.properties().defaultValue())) {
                if (this.properties().controllerPlug().value() == null) {
                    this.properties().setDefaultValue(this.properties().min());
                } else {
                    float f = 0.0f;
                    if (this.properties().controllerPlug().value() instanceof Boolean) {
                        boolean bl = new Boolean(this.properties().controllerPlug().value().toString());
                        f = bl ? 1.0f : 0.0f;
                    } else if (this.properties().controllerPlug().value() instanceof Float) {
                        f = new Float(this.properties().controllerPlug().value().toString()).floatValue();
                    } else if (this.properties().controllerPlug().value() instanceof Integer) {
                        f = new Integer(this.properties().controllerPlug().value().toString()).intValue();
                    } else if (this.properties().controllerPlug().value() instanceof String) {
                        this._myStringValue = this.properties().controllerPlug().value().toString();
                    }
                    this.properties().setDefaultValue(f);
                }
            }
        } else if (Float.isNaN(this.properties().defaultValue())) {
            this.properties().setDefaultValue(this.properties().min());
        }
        this.getBoundingBox();
        if (this.properties().controllerPlug() != null) {
            if (this.properties().controllerPlug().parameterType() == 3) {
                this.broadcast(this._myStringValue);
            } else {
                this.broadcast(this.properties().defaultValue());
            }
        }
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this.adjustValue(this.properties().defaultValue()));
        }
        this._myLabel.set("" + this.properties().label().toUpperCase());
        this.setup();
    }

    protected void status() {
        if (this.isInsideBoundingBox) {
            if (ControlP5.keyHandler.isAltDown) {
                if (this.isMousePressed) {
                    this.isMouseDown = true;
                }
            } else {
                if (!this.isActive && this.isMousePressed) {
                    this.isMouseDown = true;
                }
                if (this.isInside) {
                    if (!this.isActive) {
                        this.onEnter();
                    }
                    this.isActive = true;
                    this._myPreviousMousePosition.set(this._myMousePosition);
                    if (this.isMousePressed) {
                        if (!this.isMouseDown) {
                            this.onClick();
                        }
                        this.isMouseDown = true;
                    }
                } else if (!this.isMouseDown) {
                    this.isActive = false;
                }
            }
        }
    }

    protected boolean update() {
        if (this.isMouseDown) {
            if (ControlP5.keyHandler.isAltDown && !ControlP5.isLock) {
                int n;
                int n2;
                if (ControlP5.keyHandler.isShiftDown) {
                    n2 = (int)this._myMousePosition.x() / 10 * 10;
                    n = (int)this._myMousePosition.y() / 10 * 10;
                } else {
                    n2 = (int)this._myMousePosition.x();
                    n = (int)this._myMousePosition.y();
                }
                this.properties().setPosition(n2, n);
                this.getBoundingBox();
                return true;
            }
            if (this.isActive) {
                this.setValue();
            }
        }
        return false;
    }

    public ControlWindow window() {
        return this._myControlWindow;
    }

    public int id() {
        return this._myId;
    }

    public void setId(int n) {
        this._myId = n;
        this.broadcast(this._myValue);
    }

    public void setWindow(ControlWindow controlWindow) {
        this.setWindow(controlWindow.papplet(), "default");
    }

    public void setWindow(ControlWindow controlWindow, String string) {
        this.setWindow(controlWindow.papplet(), string);
    }

    public void setWindow(PApplet pApplet) {
        this.setWindow(pApplet, "default");
    }

    public void setWindow(PApplet pApplet, String string) {
        if (this._myControlWindow != null) {
            this._myControlWindow.tab(this._myTabName).remove(this);
        }
        this._myTabName = string;
        this._myControlWindow = ControllerProperties.controlP5.setWindow(pApplet, this._myTabName);
        this._myControlWindow.tab(this._myTabName).add(this);
        this.setColorActive(this._myControlWindow.tab((String)this._myTabName).colorActive);
        this.setColorBackground(this._myControlWindow.tab((String)this._myTabName).colorBackground);
        this.setColorForeground(this._myControlWindow.tab((String)this._myTabName).colorForeground);
        this.setColorLabel(this._myControlWindow.tab((String)this._myTabName).colorLabel);
        this.setColorValue(this._myControlWindow.tab((String)this._myTabName).colorValue);
    }

    public Tab tab() {
        return this._myControlWindow.tab(this._myTabName);
    }

    public Tab setTab(String string) {
        this.setWindow(this._myControlWindow.papplet(), string);
        return this.tab();
    }

    protected void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed();
        }
        if (keyEvent.getID() == 402) {
            this.keyReleased();
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        this._myMousePosition.set(mouseEvent.getX(), mouseEvent.getY());
        this.isInsideBoundingBox = this.insideBoundingBox(this._myMousePosition);
        this.isInside = this.isInsideBoundingBox ? this.inside(this._myMousePosition) : false;
        switch (mouseEvent.getID()) {
            case 502: {
                this.isMousePressed = false;
                this.isMouseDown = false;
                if (this.isActive && this.isInside && !ControlP5.keyHandler.isKeyDown) {
                    this.onRelease();
                }
                this.isActive = false;
                this.deactivate();
                break;
            }
            case 501: {
                if (!this.isInsideBoundingBox) break;
                this.isMousePressed = true;
            }
        }
    }

    public ControllerProperties properties() {
        return this.properties;
    }

    protected void onRelease() {
    }

    protected void onClick() {
    }

    protected void onEnter() {
    }

    protected void keyPressed() {
    }

    protected void keyReleased() {
    }

    protected void deactivate() {
    }

    public float value() {
        return this._myValue;
    }

    public String stringValue() {
        return this._myStringValue;
    }

    protected void setValue(float f) {
        this.broadcast(f);
    }

    public String name() {
        return this.properties().name();
    }

    public String label() {
        return this.properties().label();
    }

    public void setLabel(String string) {
        this.properties().setLabel(string);
        this._myLabel.set(this.properties().label());
    }

    public String target() {
        return this.properties().target();
    }

    public float defaultValue() {
        return this.properties().defaultValue();
    }

    public float unit() {
        return this.properties().unit();
    }

    public float min() {
        return this.properties().min();
    }

    public float max() {
        return this.properties().max();
    }

    public void reset() {
        this._myValue = this.properties().defaultValue();
        this.broadcast(this._myValue);
    }

    protected void constrainValueToThreshold() {
        this._myValue = Math.min(this.properties().max(), Math.max(this._myValue, this.properties().min()));
    }

    protected void broadcast(float f) {
        this._myValue = f;
        this.constrainValueToThreshold();
        ControllerProperties.controlP5.setValue(this, this.properties().target(), this._myValue);
    }

    protected void broadcast(String string) {
        this._myStringValue = string;
        ControllerProperties.controlP5.setValue(this, this.properties().target(), this._myStringValue);
    }

    public void setColorActive(int n) {
        this.properties().colorActive = n;
    }

    public void setColorForeground(int n) {
        this.properties().colorForeground = n;
    }

    public void setColorBackground(int n) {
        this.properties().colorBackground = n;
    }

    public void setColorLabel(int n) {
        this.properties().colorLabel = n;
        this._myLabel.set(this._myLabel.toString(), this.properties().colorLabel);
    }

    public void setColorValue(int n) {
        this.properties().colorValue = n;
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this._myValueLabel.toString(), this.properties().colorValue);
        }
    }

    protected String adjustValue(float f) {
        String string;
        int n;
        int n2 = 3;
        if (this.properties().controllerPlug() != null && this.properties().controllerPlug().classType() == Integer.TYPE) {
            n2 = 0;
        }
        if ((n = (string = "" + f).indexOf(46)) > -1) {
            string = string.substring(0, Math.min(string.length(), n + n2));
        }
        return string;
    }

    protected void clear() {
        this._myControlWindow = null;
    }

    protected abstract void increase();

    protected abstract void decrease();

    protected abstract void setValue();

    protected abstract boolean inside(CVector3f var1);

    protected abstract boolean insideBoundingBox(CVector3f var1);

    protected abstract void getBoundingBox();

    protected abstract ControlP5XMLElement getAsXML();

    protected abstract void setup();

    protected abstract void updateController();

    protected abstract void draw(PApplet var1);
}

