/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CRect;
import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerPlug;
import controlP5.Knob;
import controlP5.Slider;
import controlP5.Toggle;

public class ControllerProperties {
    protected CVector3f _myPosition = new CVector3f();
    protected CVector3f _myDimension = new CVector3f();
    protected CRect _myBoundingBox = new CRect();
    protected CVector3f _myLevelSize;
    protected float _myAngle = (float)Math.PI;
    protected float _myMin = 0.0f;
    protected float _myMax = 0.0f;
    protected float _myRange = 0.0f;
    protected float _myUnit = 0.0f;
    protected float _myDefaultValue = 0.0f;
    protected String target;
    protected Object targetObject;
    protected int targetType = -1;
    private final String _myName;
    private String _myLabel = "";
    private Controller _myController;
    private ControllerPlug _myControllerPlug;
    protected boolean isControllerPlug = false;
    protected static ControlP5 controlP5;
    protected int colorBackground = -11447983;
    protected int colorForeground = -8947968;
    protected int colorActive = -256;
    protected int colorLabel = -1;
    protected int colorValue = -1;

    public ControllerProperties(String string, float f, float f2, float f3) {
        this._myDefaultValue = f3;
        this._myName = string;
        this._myLabel = string;
        this._myMin = f;
        this._myMax = f2;
    }

    public ControllerProperties(String string) {
        this._myName = string;
    }

    public ControllerProperties(String string, float f, float f2, float f3, float f4, float f5, int n, int n2) {
        this._myDefaultValue = f3;
        this._myName = string;
        this._myLabel = string;
        this._myMin = f;
        this._myMax = f2;
        this.setPosition(f4, f5);
        this.setDimension(n, n2);
    }

    public ControllerProperties(Controller controller) {
        this._myController = controller;
        this._myDefaultValue = controller.defaultValue();
        this._myName = controller.name();
        this._myLabel = controller.label();
        this._myMin = controller.min();
        this._myMax = controller.max();
    }

    protected void init(Controller controller) {
        this._myController = controller;
        this.setRange(this._myMin, this._myMax);
    }

    public String label() {
        return this._myLabel;
    }

    public void setLabel(String string) {
        this._myLabel = string;
    }

    private void setRange(float f, float f2) {
        this._myMin = f;
        this._myMax = f2;
        this._myRange = this._myMax - this._myMin;
        float f3 = 1.0f;
        if (this._myController instanceof Slider) {
            int n = ((Slider)this._myController).direction();
            f3 = n == 0 ? this._myDimension.x() - this._myLevelSize.x() : this._myDimension.y() - this._myLevelSize.y();
        } else if (this._myController instanceof Toggle) {
            f3 = this._myRange;
        } else if (this._myController instanceof Knob) {
            f3 = 360.0f;
        }
        this._myUnit = this._myRange / f3;
    }

    public void setPosition(float f, float f2) {
        this._myPosition = new CVector3f(f, f2, 0.0f);
        this.updateBoundingBox();
    }

    public void setDimension(int n, int n2) {
        this._myDimension = new CVector3f(n, n2, 0.0f);
        float f = n > n2 ? (float)n2 : (float)n;
        this._myLevelSize = new CVector3f(f, f, 0.0f);
        this.updateBoundingBox();
    }

    protected CRect boundingBox() {
        return this._myBoundingBox;
    }

    protected void setBoundingBox(CRect cRect) {
        this._myBoundingBox = new CRect(cRect);
    }

    private void updateBoundingBox() {
        if (this._myController != null) {
            this._myController.getBoundingBox();
        }
    }

    public void setDefaultValue(float f) {
        this._myDefaultValue = f;
    }

    protected void setAngle(float f) {
        this._myAngle = f;
    }

    protected void setTarget(String string) {
        this.target = string;
    }

    protected void setTargetObject(Object object) {
        this.targetObject = object;
    }

    public CVector3f position() {
        return this._myPosition;
    }

    public CVector3f dimension() {
        return this._myDimension;
    }

    public CVector3f levelSize() {
        return this._myLevelSize;
    }

    public float unit() {
        return this._myUnit;
    }

    protected float adjustedUnit() {
        float f = this.unit();
        if (this.controllerPlug() != null && this.controllerPlug().classType() == Integer.TYPE && (f = (float)((int)f)) == 0.0f) {
            f = 1.0f;
        }
        return f;
    }

    public float max() {
        return this._myMax;
    }

    public float min() {
        return this._myMin;
    }

    protected void setMax(float f) {
        this._myMax = f;
        this.setRange(this._myMin, this._myMax);
    }

    protected void setMin(float f) {
        this._myMin = f;
        this.setRange(this._myMin, this._myMax);
    }

    public float defaultValue() {
        return this._myDefaultValue;
    }

    public float angle() {
        return this._myAngle;
    }

    public float range() {
        return this._myRange;
    }

    public String target() {
        return this.target;
    }

    public Object targetObject() {
        return this.targetObject;
    }

    public String name() {
        return this._myName;
    }

    protected void setControllerPlug(ControllerPlug controllerPlug) {
        this.isControllerPlug = controllerPlug != null;
        this._myControllerPlug = controllerPlug;
    }

    protected ControllerPlug controllerPlug() {
        return this._myControllerPlug;
    }
}

