/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5FileReader;
import controlP5.DropEvent;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class DropListener
implements DropTargetListener {
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getDropAction();
        if ((n & 1) != 0) {
            // empty if block
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if ((n & 0x40000000) != 0) {
            // empty if block
        }
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragAcceptable(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        dropTargetDropEvent.acceptDrop(2);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (bl) {
                System.out.println("MIME type=" + dataFlavor.getMimeType() + "\n");
            }
            try {
                DropEvent dropEvent;
                Object object;
                if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    object = (List)transferable.getTransferData(dataFlavor);
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        dropEvent = new DropEvent();
                        File file = (File)iterator.next();
                        if (!dropEvent.setFile(file)) continue;
                        dropEvent.process();
                    }
                }
                if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                    dropEvent = new DropEvent();
                    new ControlP5FileReader(dropEvent, transferable.getTransferData(DataFlavor.imageFlavor), 2);
                }
                if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
                dropEvent = new DropEvent();
                object = (String)transferable.getTransferData(dataFlavor);
                if (((String)object).toLowerCase().startsWith("http://") || ((String)object).toLowerCase().startsWith("https://")) {
                    dropEvent.setUrl((String)object);
                }
                dropEvent.setText((String)object);
                dropEvent.process();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception + "\n");
            }
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
        return (dropTargetDragEvent.getDropAction() & 3) != 0;
    }

    public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
        return (dropTargetDropEvent.getDropAction() & 3) != 0;
    }
}

