/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import processing.core.PApplet;

public class Knob
extends Controller {
    private float len;
    private float lenSquared;
    private float[] _myMarkerPosition;
    private int _myIncreaseDecreaseMultiplier = 10;

    public Knob(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this._myLabel = new Label(this.properties().label().toUpperCase(), this.properties().colorLabel);
    }

    protected void setup() {
        this.properties().position().x += this.properties().dimension().x() / 2.0f;
        this.properties().position().y += this.properties().dimension().y() / 2.0f;
        this.len = this.properties().dimension().x() / 2.0f;
        this.lenSquared = this.len * this.len;
        this._myValue = this.properties().defaultValue();
        this.getBoundingBox();
        this.updateController();
    }

    protected void draw(PApplet pApplet) {
        pApplet.noStroke();
        pApplet.fill(this.properties().colorBackground);
        pApplet.ellipse(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        if (this.isActive) {
            pApplet.fill(this.properties().colorActive);
        } else {
            pApplet.fill(this.properties().colorForeground);
        }
        pApplet.stroke(-1);
        pApplet.line(this._myMarkerPosition[0], this._myMarkerPosition[1], this._myMarkerPosition[2], this._myMarkerPosition[3]);
        pApplet.stroke(this.properties().colorActive);
        pApplet.line(this.properties().position().x(), this.properties().position().y(), this.properties().position().x() + pApplet.cos(this.properties().angle()) * this.len, this.properties().position().y() + pApplet.sin(this.properties().angle()) * this.len);
        pApplet.noStroke();
        this._myLabel.draw(pApplet, (int)(this.properties().position().x() - this.properties().dimension().x() / 2.0f), (int)(this.properties().position().y() + this.properties().dimension().y() / 2.0f) + 4, this.properties().colorLabel);
    }

    protected void setValue() {
        float f = this._myMousePosition.x() - this.properties().position().x();
        float f2 = this._myMousePosition.y() - this.properties().position().y();
        this.properties().setAngle(this._myControlWindow.papplet().atan2(f2, f));
        float f3 = this.properties().min() + ((float)Math.PI + this.properties().angle()) / ((float)Math.PI * 2) * this.properties().range();
        this.broadcast(f3);
    }

    protected void updateController() {
        float f = (this._myValue - this.properties().min()) / this.properties().range();
        this.properties().setAngle(f * ((float)Math.PI * 2) + (float)Math.PI);
    }

    protected void increase() {
        float f = this.properties().adjustedUnit();
        this._myValue += ControlP5.keyHandler.isShiftDown ? f * (float)this._myIncreaseDecreaseMultiplier : f;
        this.updateController();
    }

    protected void decrease() {
        float f = this.properties().adjustedUnit();
        this._myValue -= ControlP5.keyHandler.isShiftDown ? f * (float)this._myIncreaseDecreaseMultiplier : f;
        this.updateController();
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().boundingBox().x0() && cVector3f.x() < this.properties().boundingBox().x1() && cVector3f.y() > this.properties().boundingBox().y() && cVector3f.y() < this.properties().boundingBox().y1();
    }

    protected void getBoundingBox() {
        int n = (int)Math.max(this.properties().dimension().x(), (float)this._myLabel.width());
        int n2 = (int)(this.properties().dimension().y() + (float)this._myLabel.height());
        int n3 = (int)(this.properties().position().x() - this.properties().dimension().x() / 2.0f);
        int n4 = (int)(this.properties().position().y() - this.properties().dimension().y() / 2.0f);
        this.properties().boundingBox().x0(n3);
        this.properties().boundingBox().y0(n4);
        this.properties().boundingBox().x1(n3 + n);
        this.properties().boundingBox().y1(n4 + n2);
        this._myMarkerPosition = new float[]{this.properties().position().x() + (float)Math.cos(-3.1415927410125732) * this.len / 2.0f, this.properties().position().y() + (float)Math.sin(-3.1415927410125732) * this.len / 2.0f, this.properties().position().x() + (float)Math.cos(-3.1415927410125732) * this.len, this.properties().position().y() + (float)Math.sin(-3.1415927410125732) * this.len};
    }

    protected boolean inside(CVector3f cVector3f) {
        return (cVector3f.x() - this.properties().position().x()) * (cVector3f.x() - this.properties().position().x()) + (cVector3f.y() - this.properties().position().y()) * (cVector3f.y() - this.properties().position().y()) < this.lenSquared;
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "knob");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x() - this.properties().dimension().x() / 2.0f));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y() - this.properties().dimension().y() / 2.0f));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    protected static Knob build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addKnob(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("min"), (float)controlP5XMLElement.getDoubleAttribute("max"), (float)controlP5XMLElement.getDoubleAttribute("value"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"));
    }
}

