/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import processing.core.PApplet;
import processing.core.PImage;

public class Label {
    private PImage _myImage;
    private String _myText;
    private int _myWidth;
    private int _myHeight;
    private int _myColor;
    private boolean isToUpperCase = true;
    private boolean isFixedSize = false;
    public static final BitFontRenderer bitFontRenderer = new BitFontRenderer();
    private int _myFont = 0;
    private int _myCursorPosition = -1;

    public Label(String string) {
        this(string, bitFontRenderer.getWidth(string.toUpperCase()), 10, -1);
    }

    public Label(String string, int n) {
        this(string, bitFontRenderer.getWidth(string.toUpperCase()), 10, n);
    }

    public Label(String string, int n, int n2) {
        this(string, n, n2, -1);
    }

    public Label(String string, int n, int n2, int n3) {
        if (string == null) {
            string = "";
        }
        this._myText = string;
        this._myWidth = n;
        this._myHeight = n2;
        this._myColor = n3;
        this._myImage = new PImage(this._myWidth, this._myHeight);
        this.set(this._myText);
    }

    public void toUpperCase(boolean bl) {
        this.isToUpperCase = bl;
    }

    protected void draw(PApplet pApplet, int n, int n2) {
        if (this._myImage.width > 0 && this._myImage.height > 0) {
            pApplet.image(this._myImage, (float)n, (float)n2);
        }
    }

    protected void draw(PApplet pApplet, int n, int n2, int n3) {
        if (this._myImage.width > 0 && this._myImage.height > 0) {
            this._myColor = n3;
            pApplet.image(this._myImage, (float)n, (float)n2);
        }
    }

    public void set(String string) {
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void set(String string, int n) {
        this._myColor = n;
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void setWithCursorPosition(String string, int n) {
        this.set(string, this._myColor, n);
    }

    public void setFont(int n) {
        this._myFont = n;
    }

    protected void set(String string, int n, int n2) {
        int n3;
        this._myCursorPosition = n2;
        bitFontRenderer.setFont(this._myFont);
        if (string == null) {
            string = "";
        }
        if (!this.isFixedSize && (n3 = bitFontRenderer.getWidth(string)) > this._myWidth) {
            this._myWidth = n3;
            this._myImage = new PImage(n3, this._myHeight);
        }
        this._myText = this.isToUpperCase ? string.toUpperCase() : string;
        this._myColor = n;
        bitFontRenderer.write(this._myImage, this._myText, 0, 0, this._myColor, n2);
        this._myImage.updatePixels();
    }

    public void fixedSize(boolean bl) {
        this.isFixedSize = bl;
    }

    public int color() {
        return this._myColor;
    }

    public int color(int n) {
        this._myColor = n;
        this.set(this._myText, n);
        return this._myColor;
    }

    public String toString() {
        return this._myText;
    }

    public int width() {
        return this._myWidth;
    }

    public int height() {
        return this._myHeight;
    }
}

