/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PApplet;

public class PAppletWindow
extends PApplet
implements WindowListener,
ComponentListener {
    int width = 600;
    int height = 200;
    int x = 100;
    int y = 100;
    private String _myName;
    protected boolean isLoop = true;
    public static ControlP5 controlP5;

    public PAppletWindow() {
    }

    public PAppletWindow(String string, int n, int n2) {
        this._myName = string;
        this.width = n;
        this.height = n2;
        this.launch();
    }

    public PAppletWindow(String string, int n, int n2, int n3, int n4) {
        this._myName = string;
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this.launch();
    }

    public String name() {
        return this._myName;
    }

    protected void visible(boolean bl) {
        this.frame.setVisible(bl);
    }

    protected void resizeable(boolean bl) {
        this.frame.setResizable(bl);
    }

    public void setup() {
        this.size(this.width, this.height);
        String string = "frameRate";
        Method[] methodArray = this.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().toLowerCase().equals("framerate")) continue;
            string = methodArray[i].getName();
            break;
        }
        try {
            Method method = this.getClass().getMethod(string, Float.TYPE);
            method.invoke((Object)this, new Float(15.0f));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void draw() {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.isLoop = true;
        this.loop();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.visible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this.isLoop = false;
        this.noLoop();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.x = component.getLocation().x;
        this.y = component.getLocation().y;
        this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   " + this.width + "x" + this.height);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        System.out.println("componentResized event from " + component.getClass().getName() + "; new size: " + component.getSize().width + ", " + component.getSize().height);
    }

    public void componentShown(ComponentEvent componentEvent) {
        System.out.println("componentShown event from " + componentEvent.getComponent().getClass().getName());
    }

    protected void dispose() {
        this.stop();
        this.removeAll();
        this.frame.removeAll();
        this.frame.dispose();
    }

    private void launch() {
        try {
            this.frame = new Frame();
            this.init();
            this.start();
            this.frame.setBackground(Color.black);
            this.frame.setLayout(new GridBagLayout());
            this.frame.add((Component)((Object)this));
            this.frame.pack();
            this.frame.setLocation(this.x, this.y);
            this.frame.show();
            this.frame.pack();
            Insets insets = this.frame.getInsets();
            int n = this.width;
            int n2 = this.height;
            this.frame.setSize(n - 2, n2 - 2);
            this.frame.setName(this._myName);
            this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   w:" + this.width + " h:" + this.height);
            this.requestFocus();
            this.frame.setResizable(false);
            this.frame.addWindowListener(this);
            this.frame.addComponentListener(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

