/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public class Radio
extends Controller {
    Vector _myRadioButtons;
    private int myLineSpacing = 14;
    int labelOffsetX = 14;
    int labelOffsetY = 2;
    CVector3f _myMousePosition = new CVector3f();
    RadioButton _myCurrentRadioButton;
    int _myRadioButtonWidth = 10;
    int _myRadioButtonHeight = 10;

    public Radio(ControllerProperties controllerProperties) {
        super(controllerProperties);
        System.out.println("### Radio constructor " + this.properties().label());
        this._myLabel = new Label(this.properties().label(), this.properties().colorLabel);
    }

    protected void setup() {
        this.properties().setMin(-1000000.0f);
        this.properties().setMax(1000000.0f);
        this._myRadioButtons = new Vector();
    }

    public RadioButton add(String string, int n) {
        RadioButton radioButton = new RadioButton(0, this._myRadioButtons.size() * this.myLineSpacing, string, n);
        this._myRadioButtons.add(radioButton);
        this.getDimensions();
        if (this._myRadioButtons.size() == 1) {
            this.activate(radioButton.name());
        }
        return radioButton;
    }

    private void getDimensions() {
        int n = 0;
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            int n2 = ((RadioButton)this._myRadioButtons.get((int)i)).label.width() + this.labelOffsetX;
            n = n2 > n ? n2 : n;
        }
        this.properties().setDimension(n, this._myRadioButtons.size() * this.myLineSpacing);
    }

    protected void draw(PApplet pApplet) {
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            ((RadioButton)this._myRadioButtons.get(i)).draw(pApplet);
        }
    }

    protected void setValue() {
    }

    protected void updateController() {
        if (this.current() != null) {
            for (int i = 0; i < this._myRadioButtons.size(); ++i) {
                RadioButton radioButton = (RadioButton)this._myRadioButtons.get(i);
                if (radioButton == this.current()) {
                    radioButton.activate();
                    this._myValue = radioButton.value;
                    this.broadcast(this._myValue);
                    continue;
                }
                radioButton.deactivate();
            }
        }
    }

    protected void increase() {
        this.cycle(1);
    }

    protected void decrease() {
        this.cycle(-1);
    }

    private void cycle(int n) {
        System.out.println("### " + this.current());
        if (this.current() != null) {
            int n2 = this._myRadioButtons.indexOf(this.current());
            if ((n2 += n) > this._myRadioButtons.size() - 1) {
                n2 = 0;
            }
            if (n2 < 0) {
                n2 = this._myRadioButtons.size() - 1;
            }
            this.current((RadioButton)this._myRadioButtons.get(n2));
            this.updateController();
        }
    }

    protected boolean inside(CVector3f cVector3f) {
        return this.isInsideBoundingBox;
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        this._myMousePosition.set(cVector3f);
        return cVector3f.x() > this.properties().position().x() && cVector3f.x() < this.properties().position().x() + this.properties().dimension().x() && cVector3f.y() > this.properties().position().y() && cVector3f.y() < this.properties().position().y() + this.properties().dimension().y();
    }

    protected void getBoundingBox() {
    }

    protected void onRelease() {
        this.updateController();
    }

    public void current(RadioButton radioButton) {
        this._myCurrentRadioButton = radioButton;
    }

    public RadioButton current() {
        return this._myCurrentRadioButton;
    }

    public void activate(String string) {
        string = string.toUpperCase();
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            RadioButton radioButton = (RadioButton)this._myRadioButtons.get(i);
            if (!string.equals(radioButton.name())) continue;
            this.current((RadioButton)this._myRadioButtons.get(i));
            this.updateController();
            return;
        }
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "radio");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        for (int i = 0; i < this._myRadioButtons.size(); ++i) {
            controlP5XMLElement.addChild(((RadioButton)this._myRadioButtons.get(i)).getAsXML());
        }
        return controlP5XMLElement;
    }

    protected static Radio build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addRadio(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"));
    }

    class RadioButton {
        int x;
        int y;
        Label label;
        int value;
        boolean isActive = false;

        RadioButton(int n, int n2, String string, int n3) {
            this.x = n;
            this.y = n2;
            this.label = new Label(string.toUpperCase());
            this.value = n3;
        }

        public String name() {
            return this.label.toString();
        }

        protected void deactivate() {
            this.isActive = false;
        }

        protected void activate() {
            this.isActive = true;
        }

        protected void draw(PApplet pApplet) {
            pApplet.noStroke();
            if (this.isActive) {
                pApplet.fill(Radio.this.properties().colorActive);
            } else {
                pApplet.fill(Radio.this.properties().colorForeground);
            }
            if (Radio.this.isInsideBoundingBox && this.inside(Radio.this._myMousePosition)) {
                pApplet.fill(Radio.this.properties().colorActive);
                if (Radio.this.isMouseDown && Radio.this.current() != this) {
                    Radio.this.current(this);
                }
            }
            pApplet.rect(Radio.this.properties().position().x() + (float)this.x, Radio.this.properties().position().y() + (float)this.y, (float)Radio.this._myRadioButtonWidth, (float)Radio.this._myRadioButtonHeight);
            this.label.draw(pApplet, (int)Radio.this.properties().position().x() + this.x + Radio.this.labelOffsetX, (int)Radio.this.properties().position().y() + this.y + Radio.this.labelOffsetY, Radio.this.properties().colorLabel);
        }

        protected boolean inside(CVector3f cVector3f) {
            return cVector3f.x() > Radio.this.properties().position().x() + (float)this.x && cVector3f.x() < Radio.this.properties().position().x() + (float)this.x + (float)Radio.this._myRadioButtonWidth && cVector3f.y() > Radio.this.properties().position().y() + (float)this.y && cVector3f.y() < Radio.this.properties().position().y() + (float)this.y + (float)Radio.this._myRadioButtonHeight;
        }

        protected ControlP5XMLElement getAsXML() {
            ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
            controlP5XMLElement.setName("radiobutton");
            controlP5XMLElement.setAttribute("type", "radiobutton");
            controlP5XMLElement.setAttribute("name", this.label.toString());
            controlP5XMLElement.setAttribute("label", this.label.toString());
            controlP5XMLElement.setAttribute("value", new Float(this.value));
            controlP5XMLElement.setAttribute("state", new Integer(this.isActive ? 1 : 0));
            return controlP5XMLElement;
        }
    }
}

