/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import processing.core.PApplet;

public class Slider
extends Controller {
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    private int _myDirection;
    public static final int FIX = 1;
    public static final int FLEXIBLE = 0;
    private int _mySliderMode = 1;
    private int _myIncreaseDecreaseMultiplier = 10;

    public Slider(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this.direction();
        this._myLabel = new Label(this.properties().label().toUpperCase(), this.properties().colorLabel);
        this._myValueLabel = new Label("" + this.adjustValue(this.properties().defaultValue()), 100, 10, this.properties().colorLabel);
    }

    protected void setup() {
        this._myMousePosition.x = (this.properties().defaultValue() - this.properties().min()) / this.properties().unit() + this.properties().position().x();
        this._myMousePosition.y = this.properties().dimension().y() - (this.properties().defaultValue() - this.properties().min()) / this.properties().unit() + this.properties().position().y();
        this._myValue = this.properties().defaultValue();
    }

    protected void direction(int n) {
        if (n == 0 || n == 1) {
            this._myDirection = n;
        }
        this.getBoundingBox();
    }

    protected int direction() {
        int n = this._myDirection = this.properties().dimension().x() > this.properties().dimension().y() ? 0 : 1;
        if (this._myDirection == 0) {
            this.properties()._myLevelSize.x = 10.0f;
        }
        if (this._myDirection == 1) {
            this.properties()._myLevelSize.y = 10.0f;
        }
        return this._myDirection;
    }

    protected void draw(PApplet pApplet) {
        int n;
        int n2;
        float f;
        float f2;
        float f3;
        float f4;
        pApplet.noStroke();
        pApplet.fill(this.properties().colorBackground);
        pApplet.rect(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        if (this.isActive) {
            pApplet.fill(this.properties().colorActive);
        } else {
            pApplet.fill(this.properties().colorForeground);
        }
        if (this._myDirection == 0) {
            if (this._mySliderMode == 1) {
                f4 = this.properties().position().x();
                f3 = this.properties().position().y();
                f2 = (this._myValue - this.properties().min()) / this.properties().unit() + this.properties().levelSize().x();
                f = this.properties().levelSize().y();
            } else {
                f4 = this.properties().position().x() + (this._myValue - this.properties().min()) / this.properties().unit();
                f3 = this.properties().position().y();
                f2 = this.properties().levelSize().x();
                f = this.properties().levelSize().y();
            }
            n2 = (int)f4;
            n = (int)(f3 - 10.0f);
        } else {
            if (this._mySliderMode == 1) {
                f4 = this.properties().position().x();
                f3 = this.properties().position().y() + this.properties().dimension().y() - this.properties().levelSize().y() - (this._myValue - this.properties().min()) / this.properties().unit();
                f2 = this.properties().levelSize().x();
                f = (this._myValue - this.properties().min()) / this.properties().unit() + this.properties().levelSize().y();
            } else {
                f4 = this.properties().position().x();
                f3 = this.properties().position().y() + this.properties().dimension().y() - this.properties().levelSize().y() - (this._myValue - this.properties().min()) / this.properties().unit();
                f2 = this.properties().levelSize().x();
                f = this.properties().levelSize().y();
            }
            n2 = (int)(f4 + this.properties().levelSize().x() + 4.0f);
            n = (int)(f3 + 2.0f);
        }
        pApplet.rect(f4, f3, f2, f);
        this._myValueLabel.draw(pApplet, n2, n, this.properties().colorLabel);
        this._myLabel.draw(pApplet, (int)this.properties().position().x(), (int)(this.properties().position().y() + this.properties().dimension().y()) + 4, this.properties().colorLabel);
    }

    protected void setValue() {
        this._myValue = this._myDirection == 0 ? (this._myMousePosition.x() - this.properties().position().x() - this.properties().levelSize().y() / 2.0f) * this.properties().unit() + this.properties().min() : (this.properties().dimension().y() - (this.properties().levelSize().y() / 2.0f + this._myMousePosition.y() - this.properties().position().y())) * this.properties().unit() + this.properties().min();
        this.updateController();
        this.broadcast(this._myValue);
    }

    protected void updateController() {
        this.constrainValueToThreshold();
        this._myValueLabel.set(this.adjustValue(this._myValue));
    }

    protected void increase() {
        float f = this.properties().adjustedUnit();
        this._myValue += ControlP5.keyHandler.isShiftDown ? f * (float)this._myIncreaseDecreaseMultiplier : f;
        this.updateController();
    }

    protected void decrease() {
        float f = this.properties().adjustedUnit();
        this._myValue -= ControlP5.keyHandler.isShiftDown ? f * (float)this._myIncreaseDecreaseMultiplier : f;
        this.updateController();
    }

    protected void getBoundingBox() {
        this.properties().boundingBox().x0(this.properties().position().x() - 8.0f);
        this.properties().boundingBox().y0(this.properties().position().y() - 8.0f);
        this.properties().boundingBox().x1(this.properties().position().x() + 8.0f + Math.max(this.properties().dimension().x(), (float)this._myLabel.width()));
        this.properties().boundingBox().y1(this.properties().position().y() + 8.0f + (this.properties().dimension().y() + (float)this._myLabel.height()));
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().boundingBox().x0() && cVector3f.x() < this.properties().boundingBox().x1() && cVector3f.y() > this.properties().boundingBox().y0() && cVector3f.y() < this.properties().boundingBox().y1();
    }

    protected boolean inside(CVector3f cVector3f) {
        if (this._myDirection == 0) {
            return cVector3f.x() > this.properties().position().x() + (this._myValue - this.properties().min()) / this.properties().unit() && cVector3f.x() < this.properties().position().x() + (this._myValue - this.properties().min()) / this.properties().unit() + this.properties().levelSize().x() && cVector3f.y() > this.properties().position().y() && cVector3f.y() < this.properties().position().y() + this.properties().levelSize().y();
        }
        return cVector3f.x() > this.properties().position().x() && cVector3f.x() < this.properties().position().x() + this.properties().levelSize().x() && cVector3f.y() > this.properties().position().y() + this.properties().dimension().y() - (this._myValue - this.properties().min()) / this.properties().unit() - this.properties().levelSize().y() && cVector3f.y() < this.properties().position().y() + this.properties().dimension().y() - (this._myValue - this.properties().min()) / this.properties().unit();
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "slider");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    protected static Slider build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addSlider(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("min"), (float)controlP5XMLElement.getDoubleAttribute("max"), (float)controlP5XMLElement.getDoubleAttribute("value"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
    }
}

