/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerList;
import controlP5.Label;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import processing.core.PApplet;

public class Tab {
    private ControllerList _myControllerList;
    private boolean isActive = false;
    private final String _myName;
    private ControlWindow _myControlWindow;
    private int _myIndex;
    private int _myX;
    private int _myY;
    private int _myWidth;
    private int _myHeight;
    private Label _myLabel;
    protected int colorForeground;
    protected int colorActive;
    protected int colorLabel;
    protected int colorValue;
    protected int colorBackground;

    public Tab(ControlWindow controlWindow, String string, int n) {
        this._myControlWindow = controlWindow;
        this.setIndex(n);
        this.colorActive = this._myControlWindow.colorActive;
        this.colorBackground = this._myControlWindow.colorBackground;
        this.colorForeground = this._myControlWindow.colorForeground;
        this.colorLabel = this._myControlWindow.colorLabel;
        this.colorValue = this._myControlWindow.colorValue;
        this._myName = string;
        this._myLabel = new Label(this._myName.toUpperCase(), this.colorLabel);
        this._myControllerList = new ControllerList();
    }

    protected void setIndex(int n) {
        this._myIndex = n;
        this._myWidth = 100;
        this._myHeight = 15;
        this._myX = n * this._myWidth;
        this._myY = 0;
    }

    protected int index() {
        return this._myIndex;
    }

    protected void add(Controller controller) {
        this._myControllerList.add(controller);
    }

    public String name() {
        return this._myName;
    }

    protected void activate(boolean bl) {
        this.isActive = bl;
    }

    protected void remove(Controller controller) {
        this._myControllerList.remove(controller);
    }

    protected void clear() {
        this._myControlWindow = null;
        this._myControllerList.clear();
    }

    protected void update(PApplet pApplet, boolean bl) {
        if (this.isActive) {
            boolean bl2 = false;
            for (int i = 0; i < this._myControllerList.size(); ++i) {
                if (!bl2) {
                    this._myControllerList.get(i).status();
                    bl2 = this._myControllerList.get(i).update();
                }
                this._myControllerList.get(i).draw(pApplet);
            }
        }
    }

    protected void draw(PApplet pApplet, boolean bl) {
        if (bl) {
            pApplet.noStroke();
            pApplet.fill(this.isActive ? this.colorActive : this.colorBackground);
            pApplet.rect((float)this._myX, (float)this._myY, (float)this._myWidth, (float)this._myHeight);
            this._myLabel.draw(pApplet, this._myX + 4, this._myY + 4, this.colorLabel);
        }
    }

    public ControlWindow window() {
        return this._myControlWindow;
    }

    public ControllerList controllerList() {
        return this._myControllerList;
    }

    protected void mouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500 && this.isInside(new int[]{mouseEvent.getX(), mouseEvent.getY()})) {
            this._myControlWindow.activate(this);
        }
        if (this.isActive) {
            for (int i = 0; i < this._myControllerList.size(); ++i) {
                this._myControllerList.get(i).mouseEvent(mouseEvent);
            }
        }
    }

    protected void keyEvent(KeyEvent keyEvent) {
        if (this.isActive) {
            for (int i = 0; i < this._myControllerList.size(); ++i) {
                this._myControllerList.get(i).keyEvent(keyEvent);
            }
        }
    }

    public void setColorActive(int n) {
        this.colorActive = n;
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.colorForeground = n;
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.colorBackground = n;
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.colorLabel = n;
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.colorValue = n;
        for (int i = 0; i < this._myControllerList.size(); ++i) {
            this._myControllerList.get(i).setColorValue(n);
        }
    }

    private boolean isInside(int[] nArray) {
        return nArray[0] > this._myX && nArray[0] < this._myX + this._myWidth && nArray[1] > this._myY && nArray[1] < this._myY + this._myHeight;
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("tab");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.colorValue));
        return controlP5XMLElement;
    }
}

