/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.ArrayList;
import java.util.Hashtable;
import processing.core.PApplet;

public class Textfield
extends Controller {
    ArrayList myTextList = new ArrayList();
    int myIndex = 1;
    int myPosition = 0;
    StringBuffer myTextline = new StringBuffer();
    private boolean isTexfieldActive = false;

    public Textfield(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this._myLabel = new Label(this.properties().label().toUpperCase() + "        ", this.properties().colorLabel);
        this._myValueLabel = new Label(">", (int)(this.properties().dimension().x() - 8.0f), 15);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.fixedSize(true);
        this._myValueLabel.setFont(1);
    }

    protected void setup() {
        this.getBoundingBox();
        this._myValueLabel.set(">");
    }

    protected void setValue() {
    }

    protected void updateController() {
    }

    protected void increase() {
    }

    protected void decrease() {
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().boundingBox().x0() && cVector3f.x() < this.properties().boundingBox().x1() && cVector3f.y() > this.properties().boundingBox().y0() && cVector3f.y() < this.properties().boundingBox().y1();
    }

    protected void getBoundingBox() {
        this.properties().boundingBox().x0(this.properties().position().x());
        this.properties().boundingBox().y0(this.properties().position().y());
        this.properties().boundingBox().x1(this.properties().position().x() + Math.max(this.properties().dimension().x(), (float)this._myLabel.width()));
        this.properties().boundingBox().y1(this.properties().position().y() + this.properties().dimension().y());
    }

    protected boolean inside(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().position().x() && cVector3f.x() < this.properties().position().x() + this.properties().dimension().x() && cVector3f.y() > this.properties().position().y() && cVector3f.y() < this.properties().position().y() + this.properties().dimension().y();
    }

    protected void onClick() {
        this.isActive = true;
        this.isTexfieldActive = true;
    }

    protected void deactivate() {
        if (!this.isInside) {
            this.isActive = false;
            this.isTexfieldActive = false;
        }
    }

    protected void draw(PApplet pApplet) {
        if (this.isTexfieldActive && this.isActive) {
            pApplet.stroke(this.properties().colorActive);
        } else {
            pApplet.stroke(this.properties().colorForeground);
        }
        pApplet.fill(this.properties().colorBackground);
        pApplet.rect(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        this._myValueLabel.draw(pApplet, (int)(this.properties().position().x() + 4.0f), (int)(this.properties().position().y() + 7.0f), this.properties().colorValue);
        this._myLabel.draw(pApplet, (int)this.properties().position().x(), (int)(this.properties().position().y() + this.properties().dimension().y() + 4.0f), this.properties().colorLabel);
        pApplet.noFill();
        pApplet.noStroke();
    }

    protected void keyPressed() {
        if (!ControlP5.keyHandler.isAltDown && this.isTexfieldActive && this.isActive) {
            if (ControlP5.keyHandler.keyCode == 38) {
                if (this.myTextList.size() > 0 && this.myIndex > 0) {
                    --this.myIndex;
                    this.myTextline = new StringBuffer((String)this.myTextList.get(this.myIndex));
                    this.adjust();
                    this.updateLabel();
                }
            } else if (ControlP5.keyHandler.keyCode == 40) {
                ++this.myIndex;
                if (this.myIndex >= this.myTextList.size()) {
                    this.myIndex = this.myTextList.size();
                    this.myTextline = new StringBuffer();
                } else {
                    this.myTextline = new StringBuffer((String)this.myTextList.get(this.myIndex));
                }
                this.adjust();
                this.updateLabel();
            } else if (ControlP5.keyHandler.keyCode == 37) {
                if (this.myPosition > 0) {
                    --this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 39) {
                if (this.myPosition < this.myTextline.length()) {
                    ++this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 127 || ControlP5.keyHandler.keyCode == 8) {
                if (this.myTextline.length() > 0 && this.myPosition > 0) {
                    this.myTextline.deleteCharAt(this.myPosition - 1);
                    --this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 10) {
                if (this.myTextline.length() > 0) {
                    this.broadcast(this.myTextline.toString());
                    this.myTextList.add(this.myTextline.toString());
                    this.myTextline = new StringBuffer();
                    this.myIndex = this.myTextList.size();
                    this.myPosition = 0;
                    this.updateLabel();
                }
            } else if (ControlP5.keyHandler.keyCode != 16 && ControlP5.keyHandler.keyCode != 18 && ControlP5.keyHandler.keyCode != 9 && ControlP5.keyHandler.keyCode != 17 && ControlP5.keyHandler.key > '\u001f' && ControlP5.keyHandler.key < '\u007f') {
                this.myTextline.insert(this.myPosition, ControlP5.keyHandler.key);
                ++this.myPosition;
            }
            this._myValueLabel.setWithCursorPosition(this.myTextline.toString(), this.myPosition);
        }
    }

    private void updateLabel() {
        this._myLabel.set(this.properties().label().toUpperCase() + " " + this.myIndex + "/" + this.myTextList.size());
    }

    protected void adjust() {
        this.myPosition = this.myTextline.length();
        if (this.myPosition < 0) {
            this.myPosition = 0;
        }
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "textfield");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("value", this.stringValue());
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    protected static Textfield build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addTextfield(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
    }
}

