/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CVector3f;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerProperties;
import controlP5.Label;
import java.util.Hashtable;
import processing.core.PApplet;

public class Toggle
extends Controller {
    private boolean isOn = false;
    private int colorState;

    public Toggle(ControllerProperties controllerProperties) {
        super(controllerProperties);
        this.colorState = this.properties().colorForeground;
        this._myLabel = new Label(this.properties().label().toUpperCase(), this.properties().colorLabel);
    }

    protected void setup() {
        this.ignoreMousedown = true;
        this.isOn = this.properties().defaultValue() == 1.0f;
        this.colorState = this.isOn ? this.properties().colorActive : this.properties().colorForeground;
    }

    public void draw(PApplet pApplet) {
        pApplet.noStroke();
        pApplet.fill(this.colorState);
        pApplet.rect(this.properties().position().x(), this.properties().position().y(), this.properties().dimension().x(), this.properties().dimension().y());
        this._myLabel.draw(pApplet, (int)this.properties().position().x(), (int)(this.properties().position().y() + this.properties().dimension().y()) + 4, this.properties().colorLabel);
    }

    protected void setValue() {
    }

    protected void updateController() {
        this.colorState = this.isOn ? this.properties().colorActive : this.properties().colorForeground;
    }

    protected void increase() {
        this.setState(true);
        this.updateController();
    }

    protected void decrease() {
        this.setState(false);
        this.updateController();
    }

    public void onRelease() {
        this.setState(!this.isOn);
    }

    public void setState(boolean bl) {
        this.isOn = bl;
        this.updateController();
        this.broadcast(!this.isOn ? 0.0f : 1.0f);
    }

    protected boolean insideBoundingBox(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().boundingBox().x0() && cVector3f.x() < this.properties().boundingBox().x1() && cVector3f.y() > this.properties().boundingBox().y0() && cVector3f.y() < this.properties().boundingBox().y1();
    }

    protected void getBoundingBox() {
        this.properties().boundingBox().x0(this.properties().position().x());
        this.properties().boundingBox().y0(this.properties().position().y());
        this.properties().boundingBox().x1(this.properties().position().x() + Math.max(this.properties().dimension().x(), (float)this._myLabel.width()));
        this.properties().boundingBox().y1(this.properties().position().y() + (this.properties().dimension().y() + (float)this._myLabel.height()));
    }

    protected boolean inside(CVector3f cVector3f) {
        return cVector3f.x() > this.properties().position().x() && cVector3f.x() < this.properties().position().x() + this.properties().dimension().x() && cVector3f.y() > this.properties().position().y() && cVector3f.y() < this.properties().position().y() + this.properties().dimension().y();
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("type", "toggle");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this.label());
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("x", new Float(this.properties().position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.properties().position().y()));
        controlP5XMLElement.setAttribute("width", new Integer((int)this.properties().dimension().x()));
        controlP5XMLElement.setAttribute("height", new Integer((int)this.properties().dimension().y()));
        controlP5XMLElement.setAttribute("target", "" + this.properties().target());
        controlP5XMLElement.setAttribute("colorBackground", ControlP5IOHandler.intToString(this.properties().colorBackground));
        controlP5XMLElement.setAttribute("colorForeground", ControlP5IOHandler.intToString(this.properties().colorForeground));
        controlP5XMLElement.setAttribute("colorActive", ControlP5IOHandler.intToString(this.properties().colorActive));
        controlP5XMLElement.setAttribute("colorLabel", ControlP5IOHandler.intToString(this.properties().colorLabel));
        controlP5XMLElement.setAttribute("colorValue", ControlP5IOHandler.intToString(this.properties().colorValue));
        return controlP5XMLElement;
    }

    public static Toggle build(ControlP5 controlP5, ControlP5XMLElement controlP5XMLElement) {
        return controlP5.addToggle(controlP5XMLElement.getStringAttribute("name"), (float)controlP5XMLElement.getDoubleAttribute("value") > 0.5f, (float)controlP5XMLElement.getDoubleAttribute("x"), (float)controlP5XMLElement.getDoubleAttribute("y"), controlP5XMLElement.getIntAttribute("width"), controlP5XMLElement.getIntAttribute("height"));
    }
}

